/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.DataInput;
import java.io.EOFException;
import java.io.InputStream;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.io.input.UnsupportedOperationExceptions;

public class SwappedDataInputStream
extends ProxyInputStream
implements DataInput {
    public SwappedDataInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public boolean readBoolean() {
        return 0 != this.readByte();
    }

    @Override
    public byte readByte() {
        return (byte)this.in.read();
    }

    @Override
    public char readChar() {
        return (char)this.readShort();
    }

    @Override
    public double readDouble() {
        return EndianUtils.readSwappedDouble(this.in);
    }

    @Override
    public float readFloat() {
        return EndianUtils.readSwappedFloat(this.in);
    }

    @Override
    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n2, int n3) {
        int n4;
        for (int i2 = n3; i2 > 0; i2 -= n4) {
            int n5 = n2 + n3 - i2;
            n4 = this.read(byArray, n5, i2);
            if (-1 != n4) continue;
            throw new EOFException();
        }
    }

    @Override
    public int readInt() {
        return EndianUtils.readSwappedInteger(this.in);
    }

    @Override
    public String readLine() {
        throw UnsupportedOperationExceptions.method("readLine");
    }

    @Override
    public long readLong() {
        return EndianUtils.readSwappedLong(this.in);
    }

    @Override
    public short readShort() {
        return EndianUtils.readSwappedShort(this.in);
    }

    @Override
    public int readUnsignedByte() {
        return this.in.read();
    }

    @Override
    public int readUnsignedShort() {
        return EndianUtils.readSwappedUnsignedShort(this.in);
    }

    @Override
    public String readUTF() {
        throw UnsupportedOperationExceptions.method("readUTF");
    }

    @Override
    public int skipBytes(int n2) {
        return (int)this.in.skip(n2);
    }
}

