/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.io.function.Uncheck;

public class SequenceReader
extends Reader {
    private Reader reader;
    private final Iterator readers;

    public SequenceReader(Iterable iterable) {
        this.readers = Objects.requireNonNull(iterable, "readers").iterator();
        this.reader = (Reader)Uncheck.get(this::nextReader);
    }

    public SequenceReader(Reader ... readerArray) {
        this(Arrays.asList(readerArray));
    }

    @Override
    public void close() {
        while (this.nextReader() != null) {
        }
    }

    private Reader nextReader() {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = this.readers.hasNext() ? (Reader)this.readers.next() : null;
        return this.reader;
    }

    @Override
    public int read() {
        int n2 = -1;
        while (this.reader != null && (n2 = this.reader.read()) == -1) {
            this.nextReader();
        }
        return n2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        Objects.requireNonNull(cArray, "cbuf");
        if (n3 < 0 || n2 < 0 || n2 + n3 > cArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + cArray.length + ", offset=" + n2 + ", length=" + n3);
        }
        int n4 = 0;
        while (this.reader != null) {
            int n5 = this.reader.read(cArray, n2, n3);
            if (n5 == -1) {
                this.nextReader();
                continue;
            }
            n4 += n5;
            n2 += n5;
            if ((n3 -= n5) > 0) continue;
            break;
        }
        if (n4 > 0) {
            return n4;
        }
        return -1;
    }
}

