/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.input.ReadAheadInputStream$Builder;

public class ReadAheadInputStream
extends FilterInputStream {
    private static final ThreadLocal BYTE_ARRAY_1 = ThreadLocal.withInitial(() -> new byte[1]);
    private final ReentrantLock stateChangeLock = new ReentrantLock();
    private ByteBuffer activeBuffer;
    private ByteBuffer readAheadBuffer;
    private boolean endOfStream;
    private boolean readInProgress;
    private boolean readAborted;
    private Throwable readException;
    private boolean isClosed;
    private boolean isUnderlyingInputStreamBeingClosed;
    private boolean isReading;
    private final AtomicBoolean isWaiting = new AtomicBoolean();
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private final Condition asyncReadComplete = this.stateChangeLock.newCondition();

    public static ReadAheadInputStream$Builder builder() {
        return new ReadAheadInputStream$Builder();
    }

    private static Thread newDaemonThread(Runnable runnable) {
        Thread thread = new Thread(runnable, "commons-io-read-ahead");
        thread.setDaemon(true);
        return thread;
    }

    private static ExecutorService newExecutorService() {
        return Executors.newSingleThreadExecutor(ReadAheadInputStream::newDaemonThread);
    }

    @Deprecated
    public ReadAheadInputStream(InputStream inputStream, int n2) {
        this(inputStream, n2, ReadAheadInputStream.newExecutorService(), true);
    }

    @Deprecated
    public ReadAheadInputStream(InputStream inputStream, int n2, ExecutorService executorService) {
        this(inputStream, n2, executorService, false);
    }

    private ReadAheadInputStream(InputStream inputStream, int n2, ExecutorService executorService, boolean bl2) {
        super(Objects.requireNonNull(inputStream, "inputStream"));
        if (n2 <= 0) {
            throw new IllegalArgumentException("bufferSizeInBytes should be greater than 0, but the value is " + n2);
        }
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        this.shutdownExecutorService = bl2;
        this.activeBuffer = ByteBuffer.allocate(n2);
        this.readAheadBuffer = ByteBuffer.allocate(n2);
        this.activeBuffer.flip();
        this.readAheadBuffer.flip();
    }

    @Override
    public int available() {
        this.stateChangeLock.lock();
        try {
            int n2 = (int)Math.min(Integer.MAX_VALUE, (long)this.activeBuffer.remaining() + (long)this.readAheadBuffer.remaining());
            return n2;
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    private void checkReadException() {
        if (this.readAborted) {
            if (this.readException instanceof IOException) {
                throw (IOException)this.readException;
            }
            throw new IOException(this.readException);
        }
    }

    @Override
    public void close() {
        boolean bl2 = false;
        this.stateChangeLock.lock();
        try {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            if (!this.isReading) {
                bl2 = true;
                this.isUnderlyingInputStreamBeingClosed = true;
            }
        }
        finally {
            this.stateChangeLock.unlock();
        }
        if (this.shutdownExecutorService) {
            try {
                this.executorService.shutdownNow();
                this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
                interruptedIOException.initCause(interruptedException);
                throw interruptedIOException;
            }
            finally {
                if (bl2) {
                    super.close();
                }
            }
        }
    }

    private void closeUnderlyingInputStreamIfNecessary() {
        boolean bl2 = false;
        this.stateChangeLock.lock();
        try {
            this.isReading = false;
            if (this.isClosed && !this.isUnderlyingInputStreamBeingClosed) {
                bl2 = true;
            }
        }
        finally {
            this.stateChangeLock.unlock();
        }
        if (bl2) {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isEndOfStream() {
        return !this.activeBuffer.hasRemaining() && !this.readAheadBuffer.hasRemaining() && this.endOfStream;
    }

    @Override
    public int read() {
        if (this.activeBuffer.hasRemaining()) {
            return this.activeBuffer.get() & 0xFF;
        }
        byte[] byArray = (byte[])BYTE_ARRAY_1.get();
        byArray[0] = 0;
        return this.read(byArray, 0, 1) == -1 ? -1 : byArray[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        if (!this.activeBuffer.hasRemaining()) {
            this.stateChangeLock.lock();
            try {
                this.waitForAsyncReadComplete();
                if (!this.readAheadBuffer.hasRemaining()) {
                    this.readAsync();
                    this.waitForAsyncReadComplete();
                    if (this.isEndOfStream()) {
                        int n4 = -1;
                        return n4;
                    }
                }
                this.swapBuffers();
                this.readAsync();
            }
            finally {
                this.stateChangeLock.unlock();
            }
        }
        n3 = Math.min(n3, this.activeBuffer.remaining());
        this.activeBuffer.get(byArray, n2, n3);
        return n3;
    }

    private void readAsync() {
        byte[] byArray;
        this.stateChangeLock.lock();
        try {
            byArray = this.readAheadBuffer.array();
            if (this.endOfStream || this.readInProgress) {
                return;
            }
            this.checkReadException();
            this.readAheadBuffer.position(0);
            this.readAheadBuffer.flip();
            this.readInProgress = true;
        }
        finally {
            this.stateChangeLock.unlock();
        }
        this.executorService.execute(() -> {
            this.stateChangeLock.lock();
            try {
                if (this.isClosed) {
                    this.readInProgress = false;
                    return;
                }
                this.isReading = true;
            }
            finally {
                this.stateChangeLock.unlock();
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = byArray.length;
            Throwable throwable = null;
            try {
                do {
                    if ((n2 = this.in.read(byArray, n3, n4)) <= 0) {
                        break;
                    }
                    n3 += n2;
                } while ((n4 -= n2) > 0 && !this.isWaiting.get());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                if (throwable2 instanceof Error) {
                    throw (Error)throwable2;
                }
            }
            finally {
                this.stateChangeLock.lock();
                try {
                    this.readAheadBuffer.limit(n3);
                    if (n2 < 0 || throwable instanceof EOFException) {
                        this.endOfStream = true;
                    } else if (throwable != null) {
                        this.readAborted = true;
                        this.readException = throwable;
                    }
                    this.readInProgress = false;
                    this.signalAsyncReadComplete();
                }
                finally {
                    this.stateChangeLock.unlock();
                }
                this.closeUnderlyingInputStreamIfNecessary();
            }
        });
    }

    private void signalAsyncReadComplete() {
        this.stateChangeLock.lock();
        try {
            this.asyncReadComplete.signalAll();
        }
        finally {
            this.stateChangeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l2) {
        long l3;
        if (l2 <= 0L) {
            return 0L;
        }
        if (l2 <= (long)this.activeBuffer.remaining()) {
            this.activeBuffer.position((int)l2 + this.activeBuffer.position());
            return l2;
        }
        this.stateChangeLock.lock();
        try {
            l3 = this.skipInternal(l2);
        }
        finally {
            this.stateChangeLock.unlock();
        }
        return l3;
    }

    private long skipInternal(long l2) {
        if (!this.stateChangeLock.isLocked()) {
            throw new IllegalStateException("Expected stateChangeLock to be locked");
        }
        this.waitForAsyncReadComplete();
        if (this.isEndOfStream()) {
            return 0L;
        }
        if ((long)this.available() >= l2) {
            int n2 = (int)l2;
            if ((n2 -= this.activeBuffer.remaining()) <= 0) {
                throw new IllegalStateException("Expected toSkip > 0, actual: " + n2);
            }
            this.activeBuffer.position(0);
            this.activeBuffer.flip();
            this.readAheadBuffer.position(n2 + this.readAheadBuffer.position());
            this.swapBuffers();
            this.readAsync();
            return l2;
        }
        int n3 = this.available();
        long l3 = l2 - (long)n3;
        this.activeBuffer.position(0);
        this.activeBuffer.flip();
        this.readAheadBuffer.position(0);
        this.readAheadBuffer.flip();
        long l4 = this.in.skip(l3);
        this.readAsync();
        return (long)n3 + l4;
    }

    private void swapBuffers() {
        ByteBuffer byteBuffer = this.activeBuffer;
        this.activeBuffer = this.readAheadBuffer;
        this.readAheadBuffer = byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAsyncReadComplete() {
        this.stateChangeLock.lock();
        try {
            this.isWaiting.set(true);
            while (this.readInProgress) {
                this.asyncReadComplete.await();
            }
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
        finally {
            try {
                this.isWaiting.set(false);
            }
            finally {
                this.stateChangeLock.unlock();
            }
        }
        this.checkReadException();
    }

    static /* synthetic */ ExecutorService access$000() {
        return ReadAheadInputStream.newExecutorService();
    }
}

