/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.RandomAccessFile;
import java.util.Objects;
import org.apache.commons.io.input.AbstractInputStream;
import org.apache.commons.io.input.RandomAccessFileInputStream$Builder;

public class RandomAccessFileInputStream
extends AbstractInputStream {
    private final boolean propagateClose;
    private final RandomAccessFile randomAccessFile;

    public static RandomAccessFileInputStream$Builder builder() {
        return new RandomAccessFileInputStream$Builder();
    }

    @Deprecated
    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile) {
        this(randomAccessFile, false);
    }

    @Deprecated
    public RandomAccessFileInputStream(RandomAccessFile randomAccessFile, boolean bl2) {
        this.randomAccessFile = Objects.requireNonNull(randomAccessFile, "file");
        this.propagateClose = bl2;
    }

    @Override
    public int available() {
        long l2 = this.availableLong();
        if (l2 > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    public long availableLong() {
        return this.isClosed() ? 0L : this.randomAccessFile.length() - this.randomAccessFile.getFilePointer();
    }

    @Override
    public void close() {
        super.close();
        if (this.propagateClose) {
            this.randomAccessFile.close();
        }
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    public boolean isCloseOnClose() {
        return this.propagateClose;
    }

    @Override
    public int read() {
        return this.randomAccessFile.read();
    }

    @Override
    public int read(byte[] byArray) {
        return this.randomAccessFile.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        return this.randomAccessFile.read(byArray, n2, n3);
    }

    @Override
    public long skip(long l2) {
        long l3;
        long l4;
        if (l2 <= 0L) {
            return 0L;
        }
        long l5 = this.randomAccessFile.getFilePointer();
        if (l5 >= (l4 = this.randomAccessFile.length())) {
            return 0L;
        }
        long l6 = l5 + l2;
        long l7 = l3 = l6 > l4 ? l4 - 1L : l6;
        if (l3 > 0L) {
            this.randomAccessFile.seek(l3);
        }
        return this.randomAccessFile.getFilePointer() - l5;
    }
}

