/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.input.QueueInputStream$Builder;
import org.apache.commons.io.output.QueueOutputStream;

public class QueueInputStream
extends InputStream {
    private final BlockingQueue blockingQueue;
    private final long timeoutNanos;

    public static QueueInputStream$Builder builder() {
        return new QueueInputStream$Builder();
    }

    public QueueInputStream() {
        this(new LinkedBlockingQueue());
    }

    @Deprecated
    public QueueInputStream(BlockingQueue blockingQueue) {
        this(blockingQueue, Duration.ZERO);
    }

    private QueueInputStream(BlockingQueue blockingQueue, Duration duration) {
        this.blockingQueue = Objects.requireNonNull(blockingQueue, "blockingQueue");
        this.timeoutNanos = Objects.requireNonNull(duration, "timeout").toNanos();
    }

    BlockingQueue getBlockingQueue() {
        return this.blockingQueue;
    }

    Duration getTimeout() {
        return Duration.ofNanos(this.timeoutNanos);
    }

    public QueueOutputStream newQueueOutputStream() {
        return new QueueOutputStream(this.blockingQueue);
    }

    @Override
    public int read() {
        try {
            Integer n2 = (Integer)this.blockingQueue.poll(this.timeoutNanos, TimeUnit.NANOSECONDS);
            return n2 == null ? -1 : 0xFF & n2;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(interruptedException);
        }
    }
}

