/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.commons.io.IOUtils;

public abstract class ProxyReader
extends FilterReader {
    public ProxyReader(Reader reader) {
        super(reader);
    }

    protected void afterRead(int n2) {
    }

    protected void beforeRead(int n2) {
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    protected void handleIOException(IOException iOException) {
        throw iOException;
    }

    @Override
    public synchronized void mark(int n2) {
        try {
            this.in.mark(n2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public int read() {
        try {
            this.beforeRead(1);
            int n2 = this.in.read();
            this.afterRead(n2 != -1 ? 1 : -1);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(char[] cArray) {
        try {
            this.beforeRead(IOUtils.length(cArray));
            int n2 = this.in.read(cArray);
            this.afterRead(n2);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        try {
            this.beforeRead(n3);
            int n4 = this.in.read(cArray, n2, n3);
            this.afterRead(n4);
            return n4;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(CharBuffer charBuffer) {
        try {
            this.beforeRead(IOUtils.length(charBuffer));
            int n2 = this.in.read(charBuffer);
            this.afterRead(n2);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public boolean ready() {
        try {
            return this.in.ready();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return false;
        }
    }

    @Override
    public synchronized void reset() {
        try {
            this.in.reset();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public long skip(long l2) {
        try {
            return this.in.skip(l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return 0L;
        }
    }
}

