/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.function.Erase;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOIntConsumer;
import org.apache.commons.io.input.Input;
import org.apache.commons.io.input.ProxyInputStream$AbstractBuilder;

public abstract class ProxyInputStream
extends FilterInputStream {
    private boolean closed;
    private final IOConsumer exceptionHandler = Erase::rethrow;
    private final IOIntConsumer afterRead;

    protected ProxyInputStream(ProxyInputStream$AbstractBuilder proxyInputStream$AbstractBuilder) {
        this(proxyInputStream$AbstractBuilder.getInputStream(), proxyInputStream$AbstractBuilder);
    }

    public ProxyInputStream(InputStream inputStream) {
        super(inputStream);
        this.afterRead = IOIntConsumer.NOOP;
    }

    protected ProxyInputStream(InputStream inputStream, ProxyInputStream$AbstractBuilder proxyInputStream$AbstractBuilder) {
        super(inputStream);
        this.afterRead = proxyInputStream$AbstractBuilder.getAfterRead() != null ? proxyInputStream$AbstractBuilder.getAfterRead() : IOIntConsumer.NOOP;
    }

    protected void afterRead(int n2) {
        this.afterRead.accept(n2);
    }

    @Override
    public int available() {
        if (this.in != null && !this.isClosed()) {
            try {
                return this.in.available();
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
            }
        }
        return 0;
    }

    protected void beforeRead(int n2) {
    }

    void checkOpen() {
        Input.checkOpen(!this.isClosed());
    }

    @Override
    public void close() {
        IOUtils.close((Closeable)this.in, this::handleIOException);
        this.closed = true;
    }

    protected void handleIOException(IOException iOException) {
        this.exceptionHandler.accept(iOException);
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized void mark(int n2) {
        if (this.in != null) {
            this.in.mark(n2);
        }
    }

    @Override
    public boolean markSupported() {
        return this.in != null && this.in.markSupported();
    }

    @Override
    public int read() {
        try {
            this.beforeRead(1);
            int n2 = this.in.read();
            this.afterRead(n2 != -1 ? 1 : -1);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray) {
        try {
            this.beforeRead(IOUtils.length(byArray));
            int n2 = this.in.read(byArray);
            this.afterRead(n2);
            return n2;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        try {
            this.beforeRead(n3);
            int n4 = this.in.read(byArray, n2, n3);
            this.afterRead(n4);
            return n4;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return -1;
        }
    }

    @Override
    public synchronized void reset() {
        try {
            this.in.reset();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    void setIn(InputStream inputStream) {
        this.in = inputStream;
    }

    @Override
    public long skip(long l2) {
        try {
            return this.in.skip(l2);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return 0L;
        }
    }

    public InputStream unwrap() {
        return this.in;
    }
}

