/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.input.UnsupportedOperationExceptions;

public class NullReader
extends Reader {
    public static final NullReader INSTANCE = new NullReader();
    private final long size;
    private long position;
    private long mark = -1L;
    private long readLimit;
    private boolean eof;
    private final boolean throwEofException;
    private final boolean markSupported;

    public NullReader() {
        this(0L, true, false);
    }

    public NullReader(long l2) {
        this(l2, true, false);
    }

    public NullReader(long l2, boolean bl2, boolean bl3) {
        this.size = l2;
        this.markSupported = bl2;
        this.throwEofException = bl3;
    }

    @Override
    public void close() {
        this.eof = false;
        this.position = 0L;
        this.mark = -1L;
    }

    private int doEndOfFile() {
        this.eof = true;
        if (this.throwEofException) {
            throw new EOFException();
        }
        return -1;
    }

    public long getPosition() {
        return this.position;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public synchronized void mark(int n2) {
        if (!this.markSupported) {
            throw UnsupportedOperationExceptions.mark();
        }
        this.mark = this.position;
        this.readLimit = n2;
    }

    @Override
    public boolean markSupported() {
        return this.markSupported;
    }

    protected int processChar() {
        return 0;
    }

    protected void processChars(char[] cArray, int n2, int n3) {
    }

    @Override
    public int read() {
        if (this.eof) {
            throw new IOException("Read after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        ++this.position;
        return this.processChar();
    }

    @Override
    public int read(char[] cArray) {
        return this.read(cArray, 0, cArray.length);
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        if (this.eof) {
            throw new IOException("Read after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        this.position += (long)n3;
        int n4 = n3;
        if (this.position > this.size) {
            n4 = n3 - (int)(this.position - this.size);
            this.position = this.size;
        }
        this.processChars(cArray, n2, n4);
        return n4;
    }

    @Override
    public synchronized void reset() {
        if (!this.markSupported) {
            throw UnsupportedOperationExceptions.reset();
        }
        if (this.mark < 0L) {
            throw new IOException("No position has been marked");
        }
        if (this.position > this.mark + this.readLimit) {
            throw new IOException("Marked position [" + this.mark + "] is no longer valid - passed the read limit [" + this.readLimit + "]");
        }
        this.position = this.mark;
        this.eof = false;
    }

    @Override
    public long skip(long l2) {
        if (this.eof) {
            throw new IOException("Skip after end of file");
        }
        if (this.position == this.size) {
            return this.doEndOfFile();
        }
        this.position += l2;
        long l3 = l2;
        if (this.position > this.size) {
            l3 = l2 - (this.position - this.size);
            this.position = this.size;
        }
        return l3;
    }
}

