/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.util.Objects;
import org.apache.commons.io.input.AbstractInputStream;

public class CircularInputStream
extends AbstractInputStream {
    private long byteCount;
    private int position = -1;
    private final byte[] repeatedContent;
    private final long targetByteCount;

    private static byte[] validate(byte[] byArray) {
        Objects.requireNonNull(byArray, "repeatContent");
        for (byte by : byArray) {
            if (by != -1) continue;
            throw new IllegalArgumentException("repeatContent contains the end-of-stream marker -1");
        }
        return byArray;
    }

    public CircularInputStream(byte[] byArray, long l2) {
        this.repeatedContent = CircularInputStream.validate(byArray);
        if (byArray.length == 0) {
            throw new IllegalArgumentException("repeatContent is empty.");
        }
        this.targetByteCount = l2;
    }

    @Override
    public int available() {
        return this.isClosed() ? 0 : (this.targetByteCount <= Integer.MAX_VALUE ? Math.max(Integer.MAX_VALUE, (int)this.targetByteCount) : Integer.MAX_VALUE);
    }

    @Override
    public void close() {
        super.close();
        this.byteCount = this.targetByteCount;
    }

    @Override
    public int read() {
        if (this.targetByteCount >= 0L || this.isClosed()) {
            if (this.byteCount == this.targetByteCount) {
                return -1;
            }
            ++this.byteCount;
        }
        this.position = (this.position + 1) % this.repeatedContent.length;
        return this.repeatedContent[this.position] & 0xFF;
    }
}

