/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.util.Objects;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.input.ChecksumInputStream$Builder;
import org.apache.commons.io.input.CountingInputStream;

public final class ChecksumInputStream
extends CountingInputStream {
    private final long expectedChecksumValue;
    private final long countThreshold;

    public static ChecksumInputStream$Builder builder() {
        return new ChecksumInputStream$Builder();
    }

    private ChecksumInputStream(ChecksumInputStream$Builder checksumInputStream$Builder) {
        super(new CheckedInputStream(checksumInputStream$Builder.getInputStream(), Objects.requireNonNull(ChecksumInputStream$Builder.access$100(checksumInputStream$Builder), "builder.checksum")), checksumInputStream$Builder);
        this.countThreshold = ChecksumInputStream$Builder.access$200(checksumInputStream$Builder);
        this.expectedChecksumValue = ChecksumInputStream$Builder.access$300(checksumInputStream$Builder);
    }

    @Override
    protected synchronized void afterRead(int n2) {
        super.afterRead(n2);
        if ((this.countThreshold > 0L && this.getByteCount() >= this.countThreshold || n2 == -1) && this.expectedChecksumValue != this.getChecksum().getValue()) {
            throw new IOException("Checksum verification failed.");
        }
    }

    private Checksum getChecksum() {
        return ((CheckedInputStream)this.in).getChecksum();
    }

    public long getRemaining() {
        return this.countThreshold - this.getByteCount();
    }
}

