/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntPredicate;
import org.apache.commons.io.input.AbstractCharacterFilterReader;

public class CharacterSetFilterReader
extends AbstractCharacterFilterReader {
    private static IntPredicate toIntPredicate(Set set) {
        if (set == null) {
            return SKIP_NONE;
        }
        Set set2 = Collections.unmodifiableSet(set);
        return n2 -> set2.contains(n2);
    }

    public CharacterSetFilterReader(Reader reader, Integer ... integerArray) {
        this(reader, new HashSet<Integer>(Arrays.asList(integerArray)));
    }

    public CharacterSetFilterReader(Reader reader, Set set) {
        super(reader, CharacterSetFilterReader.toIntPredicate(set));
    }
}

