/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Objects;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.input.CharSequenceInputStream$Builder;
import org.apache.commons.io.input.ReaderInputStream;

public class CharSequenceInputStream
extends InputStream {
    private static final int NO_MARK = -1;
    private final ByteBuffer bBuf;
    private int bBufMark;
    private final CharBuffer cBuf;
    private int cBufMark;
    private final CharsetEncoder charsetEncoder;

    public static CharSequenceInputStream$Builder builder() {
        return new CharSequenceInputStream$Builder();
    }

    private static CharsetEncoder newEncoder(Charset charset) {
        return Charsets.toCharset(charset).newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    @Deprecated
    public CharSequenceInputStream(CharSequence charSequence, Charset charset) {
        this(charSequence, charset, 8192);
    }

    @Deprecated
    public CharSequenceInputStream(CharSequence charSequence, Charset charset, int n2) {
        this(charSequence, n2, CharSequenceInputStream.newEncoder(charset));
    }

    private CharSequenceInputStream(CharSequence charSequence, int n2, CharsetEncoder charsetEncoder) {
        this.charsetEncoder = charsetEncoder;
        this.bBuf = ByteBuffer.allocate(ReaderInputStream.checkMinBufferSize(charsetEncoder, n2));
        this.bBuf.flip();
        this.cBuf = CharBuffer.wrap(charSequence);
        this.cBufMark = -1;
        this.bBufMark = -1;
        try {
            this.fillBuffer();
        }
        catch (CharacterCodingException characterCodingException) {
            this.bBuf.clear();
            this.bBuf.flip();
            this.cBuf.rewind();
        }
    }

    @Deprecated
    public CharSequenceInputStream(CharSequence charSequence, String string) {
        this(charSequence, string, 8192);
    }

    @Deprecated
    public CharSequenceInputStream(CharSequence charSequence, String string, int n2) {
        this(charSequence, Charsets.toCharset(string), n2);
    }

    @Override
    public int available() {
        return this.bBuf.remaining();
    }

    @Override
    public void close() {
        this.bBuf.position(this.bBuf.limit());
    }

    private void fillBuffer() {
        this.bBuf.compact();
        CoderResult coderResult = this.charsetEncoder.encode(this.cBuf, this.bBuf, true);
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        this.bBuf.flip();
    }

    CharsetEncoder getCharsetEncoder() {
        return this.charsetEncoder;
    }

    @Override
    public synchronized void mark(int n2) {
        this.cBufMark = this.cBuf.position();
        this.bBufMark = this.bBuf.position();
        this.cBuf.mark();
        this.bBuf.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() {
        do {
            if (this.bBuf.hasRemaining()) {
                return this.bBuf.get() & 0xFF;
            }
            this.fillBuffer();
        } while (this.bBuf.hasRemaining() || this.cBuf.hasRemaining());
        return -1;
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        Objects.requireNonNull(byArray, "array");
        if (n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("Array Size=" + byArray.length + ", offset=" + n2 + ", length=" + n3);
        }
        if (n3 == 0) {
            return 0;
        }
        if (!this.bBuf.hasRemaining() && !this.cBuf.hasRemaining()) {
            return -1;
        }
        int n4 = 0;
        while (n3 > 0) {
            if (this.bBuf.hasRemaining()) {
                int n5 = Math.min(this.bBuf.remaining(), n3);
                this.bBuf.get(byArray, n2, n5);
                n2 += n5;
                n3 -= n5;
                n4 += n5;
                continue;
            }
            this.fillBuffer();
            if (this.bBuf.hasRemaining() || this.cBuf.hasRemaining()) continue;
        }
        return n4 == 0 && !this.cBuf.hasRemaining() ? -1 : n4;
    }

    @Override
    public synchronized void reset() {
        if (this.cBufMark != -1) {
            if (this.cBuf.position() != 0) {
                this.charsetEncoder.reset();
                this.cBuf.rewind();
                this.bBuf.rewind();
                this.bBuf.limit(0);
                while (this.cBuf.position() < this.cBufMark) {
                    this.bBuf.rewind();
                    this.bBuf.limit(0);
                    this.fillBuffer();
                }
            }
            if (this.cBuf.position() != this.cBufMark) {
                throw new IllegalStateException("Unexpected CharBuffer position: actual=" + this.cBuf.position() + " expected=" + this.cBufMark);
            }
            this.bBuf.position(this.bBufMark);
            this.cBufMark = -1;
            this.bBufMark = -1;
        }
        this.mark(0);
    }

    @Override
    public long skip(long l2) {
        long l3 = 0L;
        while (l2 > 0L && this.available() > 0) {
            this.read();
            --l2;
            ++l3;
        }
        return l3;
    }

    static /* synthetic */ CharsetEncoder access$000(Charset charset) {
        return CharSequenceInputStream.newEncoder(charset);
    }
}

