/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.apache.commons.io.input.BufferedFileChannelInputStream$1;
import org.apache.commons.io.input.BufferedFileChannelInputStream$Builder;
import org.apache.commons.io.input.ByteBufferCleaner;
import org.apache.commons.io.input.Input;

public final class BufferedFileChannelInputStream
extends InputStream {
    private final ByteBuffer byteBuffer;
    private final FileChannel fileChannel;

    public static BufferedFileChannelInputStream$Builder builder() {
        return new BufferedFileChannelInputStream$Builder();
    }

    @Deprecated
    public BufferedFileChannelInputStream(File file) {
        this(file, 8192);
    }

    @Deprecated
    public BufferedFileChannelInputStream(File file, int n2) {
        this(file.toPath(), n2);
    }

    private BufferedFileChannelInputStream(FileChannel fileChannel, int n2) {
        this.fileChannel = Objects.requireNonNull(fileChannel, "path");
        this.byteBuffer = ByteBuffer.allocateDirect(n2);
        this.byteBuffer.flip();
    }

    @Deprecated
    public BufferedFileChannelInputStream(Path path) {
        this(path, 8192);
    }

    @Deprecated
    public BufferedFileChannelInputStream(Path path, int n2) {
        this(FileChannel.open(path, StandardOpenOption.READ), n2);
    }

    @Override
    public synchronized int available() {
        if (!this.fileChannel.isOpen()) {
            return 0;
        }
        if (!this.refill()) {
            return 0;
        }
        return this.byteBuffer.remaining();
    }

    private void clean(ByteBuffer byteBuffer) {
        if (byteBuffer.isDirect()) {
            this.cleanDirectBuffer(byteBuffer);
        }
    }

    private void cleanDirectBuffer(ByteBuffer byteBuffer) {
        if (ByteBufferCleaner.isSupported()) {
            ByteBufferCleaner.clean(byteBuffer);
        }
    }

    @Override
    public synchronized void close() {
        try {
            this.fileChannel.close();
        }
        finally {
            this.clean(this.byteBuffer);
        }
    }

    @Override
    public synchronized int read() {
        if (!this.refill()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.refill()) {
            return -1;
        }
        n3 = Math.min(n3, this.byteBuffer.remaining());
        this.byteBuffer.get(byArray, n2, n3);
        return n3;
    }

    private boolean refill() {
        Input.checkOpen(this.fileChannel.isOpen());
        if (!this.byteBuffer.hasRemaining()) {
            this.byteBuffer.clear();
            int n2 = 0;
            while (n2 == 0) {
                n2 = this.fileChannel.read(this.byteBuffer);
            }
            this.byteBuffer.flip();
            return n2 >= 0;
        }
        return true;
    }

    @Override
    public synchronized long skip(long l2) {
        if (l2 <= 0L) {
            return 0L;
        }
        if ((long)this.byteBuffer.remaining() >= l2) {
            this.byteBuffer.position(this.byteBuffer.position() + (int)l2);
            return l2;
        }
        long l3 = this.byteBuffer.remaining();
        long l4 = l2 - l3;
        this.byteBuffer.position(0);
        this.byteBuffer.flip();
        return l3 + this.skipFromFileChannel(l4);
    }

    private long skipFromFileChannel(long l2) {
        long l3 = this.fileChannel.position();
        long l4 = this.fileChannel.size();
        if (l2 > l4 - l3) {
            this.fileChannel.position(l4);
            return l4 - l3;
        }
        this.fileChannel.position(l3 + l2);
        return l2;
    }

    /* synthetic */ BufferedFileChannelInputStream(FileChannel fileChannel, int n2, BufferedFileChannelInputStream$1 bufferedFileChannelInputStream$1) {
        this(fileChannel, n2);
    }
}

