/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.InputStream;
import org.apache.commons.io.function.IOBiConsumer;
import org.apache.commons.io.input.BoundedInputStream$Builder;
import org.apache.commons.io.input.ProxyInputStream;

public class BoundedInputStream
extends ProxyInputStream {
    private long count;
    private long mark;
    private final long maxCount;
    private final IOBiConsumer onMaxCount;
    private boolean propagateClose = true;

    public static BoundedInputStream$Builder builder() {
        return new BoundedInputStream$Builder();
    }

    BoundedInputStream(BoundedInputStream$Builder boundedInputStream$Builder) {
        super(boundedInputStream$Builder);
        this.count = boundedInputStream$Builder.getCount();
        this.maxCount = boundedInputStream$Builder.getMaxCount();
        this.propagateClose = boundedInputStream$Builder.isPropagateClose();
        this.onMaxCount = boundedInputStream$Builder.getOnMaxCount();
    }

    @Deprecated
    public BoundedInputStream(InputStream inputStream) {
        this(inputStream, -1L);
    }

    BoundedInputStream(InputStream inputStream, BoundedInputStream$Builder boundedInputStream$Builder) {
        super(inputStream, boundedInputStream$Builder);
        this.count = boundedInputStream$Builder.getCount();
        this.maxCount = boundedInputStream$Builder.getMaxCount();
        this.propagateClose = boundedInputStream$Builder.isPropagateClose();
        this.onMaxCount = boundedInputStream$Builder.getOnMaxCount();
    }

    @Deprecated
    public BoundedInputStream(InputStream inputStream, long l2) {
        this(inputStream, (BoundedInputStream$Builder)BoundedInputStream.builder().setMaxCount(l2));
    }

    @Override
    protected synchronized void afterRead(int n2) {
        if (n2 != -1) {
            this.count += (long)n2;
        }
        super.afterRead(n2);
    }

    @Override
    public int available() {
        if (this.isMaxCount()) {
            this.onMaxLength(this.maxCount, this.getCount());
            return 0;
        }
        return this.in.available();
    }

    @Override
    public void close() {
        if (this.propagateClose) {
            super.close();
        }
    }

    public synchronized long getCount() {
        return this.count;
    }

    public long getMaxCount() {
        return this.maxCount;
    }

    @Deprecated
    public long getMaxLength() {
        return this.maxCount;
    }

    public long getRemaining() {
        return Math.max(0L, this.getMaxCount() - this.getCount());
    }

    private boolean isMaxCount() {
        return this.maxCount >= 0L && this.getCount() >= this.maxCount;
    }

    public boolean isPropagateClose() {
        return this.propagateClose;
    }

    @Override
    public synchronized void mark(int n2) {
        this.in.mark(n2);
        this.mark = this.count;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    protected void onMaxLength(long l2, long l3) {
        this.onMaxCount.accept(l2, l3);
    }

    @Override
    public int read() {
        if (this.isMaxCount()) {
            this.onMaxLength(this.maxCount, this.getCount());
            return -1;
        }
        return super.read();
    }

    @Override
    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) {
        if (this.isMaxCount()) {
            this.onMaxLength(this.maxCount, this.getCount());
            return -1;
        }
        return super.read(byArray, n2, (int)this.toReadLen(n3));
    }

    @Override
    public synchronized void reset() {
        this.in.reset();
        this.count = this.mark;
    }

    @Deprecated
    public void setPropagateClose(boolean bl2) {
        this.propagateClose = bl2;
    }

    @Override
    public synchronized long skip(long l2) {
        long l3 = super.skip(this.toReadLen(l2));
        this.count += l3;
        return l3;
    }

    private long toReadLen(long l2) {
        return this.maxCount >= 0L ? Math.min(l2, this.maxCount - this.getCount()) : l2;
    }

    public String toString() {
        return this.in.toString();
    }
}

