/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.FilterReader;
import java.io.Reader;
import java.util.function.IntPredicate;

public abstract class AbstractCharacterFilterReader
extends FilterReader {
    protected static final IntPredicate SKIP_NONE = n2 -> false;
    private final IntPredicate skip;

    protected AbstractCharacterFilterReader(Reader reader) {
        this(reader, SKIP_NONE);
    }

    protected AbstractCharacterFilterReader(Reader reader, IntPredicate intPredicate) {
        super(reader);
        this.skip = intPredicate == null ? SKIP_NONE : intPredicate;
    }

    protected boolean filter(int n2) {
        return this.skip.test(n2);
    }

    @Override
    public int read() {
        int n2;
        while ((n2 = this.in.read()) != -1 && this.filter(n2)) {
        }
        return n2;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) {
        int n4 = super.read(cArray, n2, n3);
        if (n4 == -1) {
            return -1;
        }
        int n5 = n2 - 1;
        for (int i2 = n2; i2 < n2 + n4; ++i2) {
            if (this.filter(cArray[i2]) || ++n5 >= i2) continue;
            cArray[n5] = cArray[i2];
        }
        return n5 - n2 + 1;
    }
}

