/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.commons.io.function.IOSpliterator;
import org.apache.commons.io.function.Uncheck;

final class UncheckedIOSpliterator
implements Spliterator {
    private final IOSpliterator delegate;

    UncheckedIOSpliterator(IOSpliterator iOSpliterator) {
        this.delegate = Objects.requireNonNull(iOSpliterator, "delegate");
    }

    @Override
    public int characteristics() {
        return this.delegate.characteristics();
    }

    @Override
    public long estimateSize() {
        return this.delegate.estimateSize();
    }

    public void forEachRemaining(Consumer consumer) {
        Uncheck.accept(this.delegate::forEachRemaining, consumer::accept);
    }

    public Comparator getComparator() {
        return this.delegate.getComparator().asComparator();
    }

    @Override
    public long getExactSizeIfKnown() {
        return this.delegate.getExactSizeIfKnown();
    }

    @Override
    public boolean hasCharacteristics(int n2) {
        return this.delegate.hasCharacteristics(n2);
    }

    public boolean tryAdvance(Consumer consumer) {
        return (Boolean)Uncheck.apply(this.delegate::tryAdvance, consumer::accept);
    }

    public Spliterator trySplit() {
        return ((IOSpliterator)Uncheck.get(this.delegate::trySplit)).unwrap();
    }
}

