/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOIndexedException;
import org.apache.commons.io.function.Erase;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOStream;

final class IOStreams {
    static final Object NONE = new Object();

    static void forAll(Stream stream, IOConsumer iOConsumer) {
        IOStreams.forAll(stream, iOConsumer, (n2, iOException) -> iOException);
    }

    static void forAll(Stream stream, IOConsumer iOConsumer, BiFunction biFunction) {
        IOStream.adapt(stream).forAll(iOConsumer, IOIndexedException::new);
    }

    static void forEach(Stream stream, IOConsumer iOConsumer) {
        IOConsumer iOConsumer2 = IOStreams.toIOConsumer(iOConsumer);
        IOStreams.of(stream).forEach(object -> Erase.accept(iOConsumer2, object));
    }

    static Stream of(Iterable iterable) {
        return iterable == null ? Stream.empty() : StreamSupport.stream(iterable.spliterator(), false);
    }

    static Stream of(Stream stream) {
        return stream == null ? Stream.empty() : stream;
    }

    @SafeVarargs
    static Stream of(Object ... objectArray) {
        return objectArray == null ? Stream.empty() : Stream.of(objectArray);
    }

    static IOConsumer toIOConsumer(IOConsumer iOConsumer) {
        return iOConsumer != null ? iOConsumer : IOConsumer.noop();
    }

    private IOStreams() {
    }
}

