/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOExceptionList;
import org.apache.commons.io.function.Erase;
import org.apache.commons.io.function.IOBaseStream;
import org.apache.commons.io.function.IOBiConsumer;
import org.apache.commons.io.function.IOBiFunction;
import org.apache.commons.io.function.IOBinaryOperator;
import org.apache.commons.io.function.IOComparator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOPredicate;
import org.apache.commons.io.function.IOStream$1;
import org.apache.commons.io.function.IOStreamAdapter;
import org.apache.commons.io.function.IOStreams;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.IOUnaryOperator;

public interface IOStream
extends IOBaseStream {
    public static IOStream adapt(Stream stream) {
        return IOStreamAdapter.adapt(stream);
    }

    public static IOStream empty() {
        return IOStreamAdapter.adapt(Stream.empty());
    }

    public static IOStream iterate(Object object, IOUnaryOperator iOUnaryOperator) {
        Objects.requireNonNull(iOUnaryOperator);
        IOStream$1 iOStream$1 = new IOStream$1(object, iOUnaryOperator);
        return IOStream.adapt(StreamSupport.stream(Spliterators.spliteratorUnknownSize(iOStream$1, 1040), false));
    }

    public static IOStream of(Iterable iterable) {
        return iterable == null ? IOStream.empty() : IOStream.adapt(StreamSupport.stream(iterable.spliterator(), false));
    }

    @SafeVarargs
    public static IOStream of(Object ... objectArray) {
        return objectArray == null || objectArray.length == 0 ? IOStream.empty() : IOStream.adapt(Arrays.stream(objectArray));
    }

    public static IOStream of(Object object) {
        return IOStream.adapt(Stream.of(object));
    }

    default public boolean allMatch(IOPredicate iOPredicate) {
        return ((Stream)this.unwrap()).allMatch((? super T object) -> Erase.test(iOPredicate, object));
    }

    default public boolean anyMatch(IOPredicate iOPredicate) {
        return ((Stream)this.unwrap()).anyMatch((? super T object) -> Erase.test(iOPredicate, object));
    }

    default public Object collect(Collector collector) {
        return ((Stream)this.unwrap()).collect(collector);
    }

    default public Object collect(IOSupplier iOSupplier, IOBiConsumer iOBiConsumer, IOBiConsumer iOBiConsumer2) {
        return ((Stream)this.unwrap()).collect(() -> Erase.get(iOSupplier), (R object, ? super T object2) -> Erase.accept(iOBiConsumer, object, object2), (R object, R object2) -> Erase.accept(iOBiConsumer2, object, object2));
    }

    default public long count() {
        return ((Stream)this.unwrap()).count();
    }

    default public IOStream distinct() {
        return IOStream.adapt(((Stream)this.unwrap()).distinct());
    }

    default public IOStream filter(IOPredicate iOPredicate) {
        return IOStream.adapt(((Stream)this.unwrap()).filter((? super T object) -> Erase.test(iOPredicate, object)));
    }

    default public Optional findAny() {
        return ((Stream)this.unwrap()).findAny();
    }

    default public Optional findFirst() {
        return ((Stream)this.unwrap()).findFirst();
    }

    default public IOStream flatMap(IOFunction iOFunction) {
        return IOStream.adapt(((Stream)this.unwrap()).flatMap((? super T object) -> (Stream)((IOStream)Erase.apply(iOFunction, object)).unwrap()));
    }

    default public DoubleStream flatMapToDouble(IOFunction iOFunction) {
        return ((Stream)this.unwrap()).flatMapToDouble((? super T object) -> (DoubleStream)Erase.apply(iOFunction, object));
    }

    default public IntStream flatMapToInt(IOFunction iOFunction) {
        return ((Stream)this.unwrap()).flatMapToInt((? super T object) -> (IntStream)Erase.apply(iOFunction, object));
    }

    default public LongStream flatMapToLong(IOFunction iOFunction) {
        return ((Stream)this.unwrap()).flatMapToLong((? super T object) -> (LongStream)Erase.apply(iOFunction, object));
    }

    default public void forAll(IOConsumer iOConsumer) {
        this.forAll(iOConsumer, (n2, iOException) -> iOException);
    }

    default public void forAll(IOConsumer iOConsumer, BiFunction biFunction) {
        AtomicReference atomicReference = new AtomicReference();
        AtomicInteger atomicInteger = new AtomicInteger();
        IOConsumer iOConsumer2 = IOStreams.toIOConsumer(iOConsumer);
        ((Stream)this.unwrap()).forEach((? super T object) -> {
            block3: {
                try {
                    iOConsumer2.accept(object);
                }
                catch (IOException iOException) {
                    if (atomicReference.get() == null) {
                        atomicReference.set(new ArrayList());
                    }
                    if (biFunction == null) break block3;
                    ((List)atomicReference.get()).add((IOException)biFunction.apply(atomicInteger.get(), iOException));
                }
            }
            atomicInteger.incrementAndGet();
        });
        IOExceptionList.checkEmpty((List)atomicReference.get(), null);
    }

    default public void forEach(IOConsumer iOConsumer) {
        ((Stream)this.unwrap()).forEach((? super T object) -> Erase.accept(iOConsumer, object));
    }

    default public void forEachOrdered(IOConsumer iOConsumer) {
        ((Stream)this.unwrap()).forEachOrdered((? super T object) -> Erase.accept(iOConsumer, object));
    }

    default public IOStream limit(long l2) {
        return IOStream.adapt(((Stream)this.unwrap()).limit(l2));
    }

    default public IOStream map(IOFunction iOFunction) {
        return IOStream.adapt(((Stream)this.unwrap()).map((? super T object) -> Erase.apply(iOFunction, object)));
    }

    default public DoubleStream mapToDouble(ToDoubleFunction toDoubleFunction) {
        return ((Stream)this.unwrap()).mapToDouble(toDoubleFunction);
    }

    default public IntStream mapToInt(ToIntFunction toIntFunction) {
        return ((Stream)this.unwrap()).mapToInt(toIntFunction);
    }

    default public LongStream mapToLong(ToLongFunction toLongFunction) {
        return ((Stream)this.unwrap()).mapToLong(toLongFunction);
    }

    default public Optional max(IOComparator iOComparator) {
        return ((Stream)this.unwrap()).max((object, object2) -> Erase.compare(iOComparator, object, object2));
    }

    default public Optional min(IOComparator iOComparator) {
        return ((Stream)this.unwrap()).min((object, object2) -> Erase.compare(iOComparator, object, object2));
    }

    default public boolean noneMatch(IOPredicate iOPredicate) {
        return ((Stream)this.unwrap()).noneMatch((? super T object) -> Erase.test(iOPredicate, object));
    }

    default public IOStream peek(IOConsumer iOConsumer) {
        return IOStream.adapt(((Stream)this.unwrap()).peek((? super T object) -> Erase.accept(iOConsumer, object)));
    }

    default public Optional reduce(IOBinaryOperator iOBinaryOperator) {
        return ((Stream)this.unwrap()).reduce((object, object2) -> Erase.apply(iOBinaryOperator, object, object2));
    }

    default public Object reduce(Object object3, IOBinaryOperator iOBinaryOperator) {
        return ((Stream)this.unwrap()).reduce(object3, (object, object2) -> Erase.apply(iOBinaryOperator, object, object2));
    }

    default public Object reduce(Object object3, IOBiFunction iOBiFunction, IOBinaryOperator iOBinaryOperator) {
        return ((Stream)this.unwrap()).reduce(object3, (U object, ? super T object2) -> Erase.apply(iOBiFunction, object, object2), (object, object2) -> Erase.apply(iOBinaryOperator, object, object2));
    }

    default public IOStream skip(long l2) {
        return IOStream.adapt(((Stream)this.unwrap()).skip(l2));
    }

    default public IOStream sorted() {
        return IOStream.adapt(((Stream)this.unwrap()).sorted());
    }

    default public IOStream sorted(IOComparator iOComparator) {
        return IOStream.adapt(((Stream)this.unwrap()).sorted((object, object2) -> Erase.compare(iOComparator, object, object2)));
    }

    default public Object[] toArray() {
        return ((Stream)this.unwrap()).toArray();
    }

    default public Object[] toArray(IntFunction intFunction) {
        return ((Stream)this.unwrap()).toArray(intFunction);
    }
}

