/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.io.function.Constants;
import org.apache.commons.io.function.Uncheck;

@FunctionalInterface
public interface IOPredicate {
    public static IOPredicate alwaysFalse() {
        return Constants.IO_PREDICATE_FALSE;
    }

    public static IOPredicate alwaysTrue() {
        return Constants.IO_PREDICATE_TRUE;
    }

    public static IOPredicate isEqual(Object object) {
        return null == object ? Objects::isNull : object2 -> object.equals(object2);
    }

    default public IOPredicate and(IOPredicate iOPredicate) {
        Objects.requireNonNull(iOPredicate);
        return object -> this.test(object) && iOPredicate.test(object);
    }

    default public Predicate asPredicate() {
        return object -> Uncheck.test(this, object);
    }

    default public IOPredicate negate() {
        return object -> !this.test(object);
    }

    default public IOPredicate or(IOPredicate iOPredicate) {
        Objects.requireNonNull(iOPredicate);
        return object -> this.test(object) || iOPredicate.test(object);
    }

    public boolean test(Object var1);
}

