/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOIteratorAdapter;
import org.apache.commons.io.function.UncheckedIOIterator;

public interface IOIterator {
    public static IOIterator adapt(Iterable iterable) {
        return IOIteratorAdapter.adapt(iterable.iterator());
    }

    public static IOIterator adapt(Iterator iterator) {
        return IOIteratorAdapter.adapt(iterator);
    }

    default public Iterator asIterator() {
        return new UncheckedIOIterator(this);
    }

    default public void forEachRemaining(IOConsumer iOConsumer) {
        Objects.requireNonNull(iOConsumer);
        while (this.hasNext()) {
            iOConsumer.accept(this.next());
        }
    }

    public boolean hasNext();

    public Object next();

    default public void remove() {
        this.unwrap().remove();
    }

    public Iterator unwrap();
}

