/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.function.Constants;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.Uncheck;

@FunctionalInterface
public interface IOFunction {
    public static IOFunction identity() {
        return Constants.IO_FUNCTION_ID;
    }

    default public IOConsumer andThen(Consumer consumer) {
        Objects.requireNonNull(consumer, "after");
        return object -> consumer.accept(this.apply(object));
    }

    default public IOFunction andThen(Function function) {
        Objects.requireNonNull(function, "after");
        return object -> function.apply(this.apply(object));
    }

    default public IOConsumer andThen(IOConsumer iOConsumer) {
        Objects.requireNonNull(iOConsumer, "after");
        return object -> iOConsumer.accept(this.apply(object));
    }

    default public IOFunction andThen(IOFunction iOFunction) {
        Objects.requireNonNull(iOFunction, "after");
        return object -> iOFunction.apply(this.apply(object));
    }

    public Object apply(Object var1);

    default public Function asFunction() {
        return object -> Uncheck.apply(this, object);
    }

    default public IOFunction compose(Function function) {
        Objects.requireNonNull(function, "before");
        return object -> this.apply(function.apply(object));
    }

    default public IOFunction compose(IOFunction iOFunction) {
        Objects.requireNonNull(iOFunction, "before");
        return object -> this.apply(iOFunction.apply(object));
    }

    default public IOSupplier compose(IOSupplier iOSupplier) {
        Objects.requireNonNull(iOSupplier, "before");
        return () -> this.apply(iOSupplier.get());
    }

    default public IOSupplier compose(Supplier supplier) {
        Objects.requireNonNull(supplier, "before");
        return () -> this.lambda$compose$8((Supplier)supplier);
    }

    private /* synthetic */ Object lambda$compose$8(Supplier supplier) {
        return this.apply(supplier.get());
    }
}

