/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.IOIndexedException;
import org.apache.commons.io.function.IOStreams;
import org.apache.commons.io.function.Uncheck;

@FunctionalInterface
public interface IOConsumer {
    public static final IOConsumer NOOP_IO_CONSUMER = object -> {};

    public static void forAll(IOConsumer iOConsumer, Iterable iterable) {
        IOStreams.forAll(IOStreams.of(iterable), iOConsumer);
    }

    public static void forAll(IOConsumer iOConsumer, Stream stream) {
        IOStreams.forAll(stream, iOConsumer, IOIndexedException::new);
    }

    @SafeVarargs
    public static void forAll(IOConsumer iOConsumer, Object ... objectArray) {
        IOStreams.forAll(IOStreams.of(objectArray), iOConsumer);
    }

    public static void forEach(Iterable iterable, IOConsumer iOConsumer) {
        IOStreams.forEach(IOStreams.of(iterable), iOConsumer);
    }

    public static void forEach(Stream stream, IOConsumer iOConsumer) {
        IOStreams.forEach(stream, iOConsumer);
    }

    public static void forEach(Object[] objectArray, IOConsumer iOConsumer) {
        IOStreams.forEach(IOStreams.of(objectArray), iOConsumer);
    }

    public static IOConsumer noop() {
        return NOOP_IO_CONSUMER;
    }

    public void accept(Object var1);

    default public IOConsumer andThen(IOConsumer iOConsumer) {
        Objects.requireNonNull(iOConsumer, "after");
        return object -> {
            this.accept(object);
            iOConsumer.accept(object);
        };
    }

    default public Consumer asConsumer() {
        return object -> Uncheck.accept(this, object);
    }
}

