/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.function;

import java.io.Closeable;
import java.util.stream.BaseStream;
import org.apache.commons.io.function.Erase;
import org.apache.commons.io.function.IOIterator;
import org.apache.commons.io.function.IOIteratorAdapter;
import org.apache.commons.io.function.IORunnable;
import org.apache.commons.io.function.IOSpliterator;
import org.apache.commons.io.function.IOSpliteratorAdapter;
import org.apache.commons.io.function.UncheckedIOBaseStream;

public interface IOBaseStream
extends Closeable {
    default public BaseStream asBaseStream() {
        return new UncheckedIOBaseStream(this);
    }

    @Override
    default public void close() {
        this.unwrap().close();
    }

    default public boolean isParallel() {
        return this.unwrap().isParallel();
    }

    default public IOIterator iterator() {
        return IOIteratorAdapter.adapt(this.unwrap().iterator());
    }

    default public IOBaseStream onClose(IORunnable iORunnable) {
        return this.wrap((BaseStream)this.unwrap().onClose(() -> Erase.run(iORunnable)));
    }

    default public IOBaseStream parallel() {
        return this.isParallel() ? this : this.wrap((BaseStream)this.unwrap().parallel());
    }

    default public IOBaseStream sequential() {
        return this.isParallel() ? this.wrap((BaseStream)this.unwrap().sequential()) : this;
    }

    default public IOSpliterator spliterator() {
        return IOSpliteratorAdapter.adapt(this.unwrap().spliterator());
    }

    default public IOBaseStream unordered() {
        return this.wrap((BaseStream)this.unwrap().unordered());
    }

    public BaseStream unwrap();

    public IOBaseStream wrap(BaseStream var1);
}

