/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class SizeFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 7388077430788600069L;
    private final boolean acceptLarger;
    private final long size;

    public SizeFileFilter(long l2) {
        this(l2, true);
    }

    public SizeFileFilter(long l2, boolean bl2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("The size must be non-negative");
        }
        this.size = l2;
        this.acceptLarger = bl2;
    }

    @Override
    public boolean accept(File file) {
        return this.accept(file != null ? file.length() : 0L);
    }

    private boolean accept(long l2) {
        return this.acceptLarger != l2 < this.size;
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        return this.get(() -> this.toFileVisitResult(this.accept(Files.size(path))));
    }

    @Override
    public String toString() {
        String string = this.acceptLarger ? ">=" : "<";
        return super.toString() + "(" + string + this.size + ")";
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        return this.toFileVisitResult(this.accept(Files.size(path)));
    }
}

