/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class OrFileFilter
extends AbstractFileFilter
implements Serializable,
ConditionalFileFilter {
    private static final long serialVersionUID = 5767770777065432721L;
    private final List fileFilters;

    public OrFileFilter() {
        this(0);
    }

    private OrFileFilter(ArrayList arrayList) {
        this.fileFilters = Objects.requireNonNull(arrayList, "initialList");
    }

    private OrFileFilter(int n2) {
        this(new ArrayList(n2));
    }

    public OrFileFilter(IOFileFilter ... iOFileFilterArray) {
        this(Objects.requireNonNull(iOFileFilterArray, "fileFilters").length);
        this.addFileFilter(iOFileFilterArray);
    }

    public OrFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        this(2);
        this.addFileFilter(iOFileFilter);
        this.addFileFilter(iOFileFilter2);
    }

    public OrFileFilter(List list) {
        this(new ArrayList(Objects.requireNonNull(list, "fileFilters")));
    }

    @Override
    public boolean accept(File file) {
        return this.fileFilters.stream().anyMatch(iOFileFilter -> iOFileFilter.accept(file));
    }

    @Override
    public boolean accept(File file, String string) {
        return this.fileFilters.stream().anyMatch(iOFileFilter -> iOFileFilter.accept(file, string));
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        return OrFileFilter.toDefaultFileVisitResult(this.fileFilters.stream().anyMatch(iOFileFilter -> iOFileFilter.accept(path, basicFileAttributes) == FileVisitResult.CONTINUE));
    }

    @Override
    public void addFileFilter(IOFileFilter iOFileFilter) {
        this.fileFilters.add(Objects.requireNonNull(iOFileFilter, "fileFilter"));
    }

    public void addFileFilter(IOFileFilter ... iOFileFilterArray) {
        Stream.of(Objects.requireNonNull(iOFileFilterArray, "fileFilters")).forEach(this::addFileFilter);
    }

    @Override
    public List getFileFilters() {
        return Collections.unmodifiableList(this.fileFilters);
    }

    @Override
    public boolean removeFileFilter(IOFileFilter iOFileFilter) {
        return this.fileFilters.remove(iOFileFilter);
    }

    @Override
    public void setFileFilters(List list) {
        this.fileFilters.clear();
        this.fileFilters.addAll(Objects.requireNonNull(list, "fileFilters"));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        this.append(this.fileFilters, stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

