/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class NameFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = 176844364689077340L;
    private final String[] names;
    private final IOCase ioCase;

    public NameFileFilter(List list) {
        this(list, null);
    }

    public NameFileFilter(List list, IOCase iOCase) {
        Objects.requireNonNull(list, "names");
        this.names = list.toArray(EMPTY_STRING_ARRAY);
        this.ioCase = this.toIOCase(iOCase);
    }

    public NameFileFilter(String string) {
        this(string, IOCase.SENSITIVE);
    }

    public NameFileFilter(String ... stringArray) {
        this(stringArray, IOCase.SENSITIVE);
    }

    public NameFileFilter(String string, IOCase iOCase) {
        Objects.requireNonNull(string, "name");
        this.names = new String[]{string};
        this.ioCase = this.toIOCase(iOCase);
    }

    public NameFileFilter(String[] stringArray, IOCase iOCase) {
        Objects.requireNonNull(stringArray, "names");
        this.names = (String[])stringArray.clone();
        this.ioCase = this.toIOCase(iOCase);
    }

    @Override
    public boolean accept(File file) {
        return file != null && this.acceptBaseName(file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        return this.acceptBaseName(string);
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        return this.toFileVisitResult(this.acceptBaseName(PathUtils.getFileNameString(path)));
    }

    private boolean acceptBaseName(String string) {
        return Stream.of(this.names).anyMatch(string2 -> this.ioCase.checkEquals(string, (String)string2));
    }

    private IOCase toIOCase(IOCase iOCase) {
        return IOCase.value(iOCase, IOCase.SENSITIVE);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        this.append(this.names, stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

