/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.RandomAccessFiles;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class MagicNumberFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -547733176983104172L;
    private final byte[] magicNumbers;
    private final long byteOffset;

    public MagicNumberFileFilter(byte[] byArray) {
        this(byArray, 0L);
    }

    public MagicNumberFileFilter(byte[] byArray, long l2) {
        Objects.requireNonNull(byArray, "magicNumbers");
        if (byArray.length == 0) {
            throw new IllegalArgumentException("The magic number must contain at least one byte");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("The offset cannot be negative");
        }
        this.magicNumbers = (byte[])byArray.clone();
        this.byteOffset = l2;
    }

    public MagicNumberFileFilter(String string) {
        this(string, 0L);
    }

    public MagicNumberFileFilter(String string, long l2) {
        Objects.requireNonNull(string, "magicNumber");
        if (string.isEmpty()) {
            throw new IllegalArgumentException("The magic number must contain at least one byte");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("The offset cannot be negative");
        }
        this.magicNumbers = string.getBytes(Charset.defaultCharset());
        this.byteOffset = l2;
    }

    @Override
    public boolean accept(File file) {
        if (file != null && file.isFile() && file.canRead()) {
            try {
                return (Boolean)RandomAccessFileMode.READ_ONLY.apply(file.toPath(), randomAccessFile -> Arrays.equals(this.magicNumbers, RandomAccessFiles.read(randomAccessFile, this.byteOffset, this.magicNumbers.length)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        if (path == null) return FileVisitResult.TERMINATE;
        if (!Files.isRegularFile(path, new LinkOption[0])) return FileVisitResult.TERMINATE;
        if (!Files.isReadable(path)) return FileVisitResult.TERMINATE;
        try (FileChannel fileChannel = FileChannel.open(path, new OpenOption[0]);){
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.magicNumbers.length);
            fileChannel.position(this.byteOffset);
            int n2 = fileChannel.read(byteBuffer);
            if (n2 != this.magicNumbers.length) {
                FileVisitResult fileVisitResult2 = FileVisitResult.TERMINATE;
                return fileVisitResult2;
            }
            FileVisitResult fileVisitResult = this.toFileVisitResult(Arrays.equals(this.magicNumbers, byteBuffer.array()));
            return fileVisitResult;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return FileVisitResult.TERMINATE;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("(");
        stringBuilder.append(new String(this.magicNumbers, Charset.defaultCharset()));
        stringBuilder.append(",");
        stringBuilder.append(this.byteOffset);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

