/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.MagicNumberFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SizeFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class FileFilterUtils {
    private static final IOFileFilter CVS_FILTER = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter("CVS")));
    private static final IOFileFilter SVN_FILTER = FileFilterUtils.notFileFilter(FileFilterUtils.and(FileFilterUtils.directoryFileFilter(), FileFilterUtils.nameFileFilter(".svn")));

    public static IOFileFilter ageFileFilter(Date date) {
        return new AgeFileFilter(date);
    }

    public static IOFileFilter ageFileFilter(Date date, boolean bl2) {
        return new AgeFileFilter(date, bl2);
    }

    public static IOFileFilter ageFileFilter(File file) {
        return new AgeFileFilter(file);
    }

    public static IOFileFilter ageFileFilter(File file, boolean bl2) {
        return new AgeFileFilter(file, bl2);
    }

    public static IOFileFilter ageFileFilter(long l2) {
        return new AgeFileFilter(l2);
    }

    public static IOFileFilter ageFileFilter(long l2, boolean bl2) {
        return new AgeFileFilter(l2, bl2);
    }

    public static IOFileFilter and(IOFileFilter ... iOFileFilterArray) {
        return new AndFileFilter(FileFilterUtils.toList(iOFileFilterArray));
    }

    @Deprecated
    public static IOFileFilter andFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return new AndFileFilter(iOFileFilter, iOFileFilter2);
    }

    public static IOFileFilter asFileFilter(FileFilter fileFilter) {
        return new DelegateFileFilter(fileFilter);
    }

    public static IOFileFilter asFileFilter(FilenameFilter filenameFilter) {
        return new DelegateFileFilter(filenameFilter);
    }

    public static IOFileFilter directoryFileFilter() {
        return DirectoryFileFilter.DIRECTORY;
    }

    public static IOFileFilter falseFileFilter() {
        return FalseFileFilter.FALSE;
    }

    public static IOFileFilter fileFileFilter() {
        return FileFileFilter.INSTANCE;
    }

    public static File[] filter(IOFileFilter iOFileFilter, File ... fileArray) {
        Objects.requireNonNull(iOFileFilter, "filter");
        if (fileArray == null) {
            return FileUtils.EMPTY_FILE_ARRAY;
        }
        return ((List)FileFilterUtils.filterFiles(iOFileFilter, Stream.of(fileArray), Collectors.toList())).toArray(FileUtils.EMPTY_FILE_ARRAY);
    }

    public static File[] filter(IOFileFilter iOFileFilter, Iterable iterable) {
        return FileFilterUtils.filterList(iOFileFilter, iterable).toArray(FileUtils.EMPTY_FILE_ARRAY);
    }

    private static Object filterFiles(IOFileFilter iOFileFilter, Stream stream, Collector collector) {
        Objects.requireNonNull(iOFileFilter, "filter");
        Objects.requireNonNull(collector, "collector");
        if (stream == null) {
            return Stream.empty().collect(collector);
        }
        return stream.filter(iOFileFilter::accept).collect(collector);
    }

    public static List filterList(IOFileFilter iOFileFilter, File ... fileArray) {
        return Arrays.asList(FileFilterUtils.filter(iOFileFilter, fileArray));
    }

    public static List filterList(IOFileFilter iOFileFilter, Iterable iterable) {
        if (iterable == null) {
            return Collections.emptyList();
        }
        return (List)FileFilterUtils.filterFiles(iOFileFilter, StreamSupport.stream(iterable.spliterator(), false), Collectors.toList());
    }

    public static Set filterSet(IOFileFilter iOFileFilter, File ... fileArray) {
        return new HashSet<File>(Arrays.asList(FileFilterUtils.filter(iOFileFilter, fileArray)));
    }

    public static Set filterSet(IOFileFilter iOFileFilter, Iterable iterable) {
        if (iterable == null) {
            return Collections.emptySet();
        }
        return (Set)FileFilterUtils.filterFiles(iOFileFilter, StreamSupport.stream(iterable.spliterator(), false), Collectors.toSet());
    }

    public static IOFileFilter magicNumberFileFilter(byte[] byArray) {
        return new MagicNumberFileFilter(byArray);
    }

    public static IOFileFilter magicNumberFileFilter(byte[] byArray, long l2) {
        return new MagicNumberFileFilter(byArray, l2);
    }

    public static IOFileFilter magicNumberFileFilter(String string) {
        return new MagicNumberFileFilter(string);
    }

    public static IOFileFilter magicNumberFileFilter(String string, long l2) {
        return new MagicNumberFileFilter(string, l2);
    }

    public static IOFileFilter makeCVSAware(IOFileFilter iOFileFilter) {
        return iOFileFilter == null ? CVS_FILTER : FileFilterUtils.and(iOFileFilter, CVS_FILTER);
    }

    public static IOFileFilter makeDirectoryOnly(IOFileFilter iOFileFilter) {
        if (iOFileFilter == null) {
            return DirectoryFileFilter.DIRECTORY;
        }
        return DirectoryFileFilter.DIRECTORY.and(iOFileFilter);
    }

    public static IOFileFilter makeFileOnly(IOFileFilter iOFileFilter) {
        if (iOFileFilter == null) {
            return FileFileFilter.INSTANCE;
        }
        return FileFileFilter.INSTANCE.and(iOFileFilter);
    }

    public static IOFileFilter makeSVNAware(IOFileFilter iOFileFilter) {
        return iOFileFilter == null ? SVN_FILTER : FileFilterUtils.and(iOFileFilter, SVN_FILTER);
    }

    public static IOFileFilter nameFileFilter(String string) {
        return new NameFileFilter(string);
    }

    public static IOFileFilter nameFileFilter(String string, IOCase iOCase) {
        return new NameFileFilter(string, iOCase);
    }

    public static IOFileFilter notFileFilter(IOFileFilter iOFileFilter) {
        return iOFileFilter.negate();
    }

    public static IOFileFilter or(IOFileFilter ... iOFileFilterArray) {
        return new OrFileFilter(FileFilterUtils.toList(iOFileFilterArray));
    }

    @Deprecated
    public static IOFileFilter orFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return new OrFileFilter(iOFileFilter, iOFileFilter2);
    }

    public static IOFileFilter prefixFileFilter(String string) {
        return new PrefixFileFilter(string);
    }

    public static IOFileFilter prefixFileFilter(String string, IOCase iOCase) {
        return new PrefixFileFilter(string, iOCase);
    }

    public static IOFileFilter sizeFileFilter(long l2) {
        return new SizeFileFilter(l2);
    }

    public static IOFileFilter sizeFileFilter(long l2, boolean bl2) {
        return new SizeFileFilter(l2, bl2);
    }

    public static IOFileFilter sizeRangeFileFilter(long l2, long l3) {
        SizeFileFilter sizeFileFilter = new SizeFileFilter(l2, true);
        SizeFileFilter sizeFileFilter2 = new SizeFileFilter(l3 + 1L, false);
        return sizeFileFilter.and(sizeFileFilter2);
    }

    public static IOFileFilter suffixFileFilter(String string) {
        return new SuffixFileFilter(string);
    }

    public static IOFileFilter suffixFileFilter(String string, IOCase iOCase) {
        return new SuffixFileFilter(string, iOCase);
    }

    public static List toList(IOFileFilter ... iOFileFilterArray) {
        return Stream.of(Objects.requireNonNull(iOFileFilterArray, "filters")).map(Objects::requireNonNull).collect(Collectors.toList());
    }

    public static IOFileFilter trueFileFilter() {
        return TrueFileFilter.TRUE;
    }
}

