/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.ConditionalFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;

public class AndFileFilter
extends AbstractFileFilter
implements Serializable,
ConditionalFileFilter {
    private static final long serialVersionUID = 7215974688563965257L;
    private final List fileFilters;

    public AndFileFilter() {
        this(0);
    }

    private AndFileFilter(ArrayList arrayList) {
        this.fileFilters = Objects.requireNonNull(arrayList, "initialList");
    }

    private AndFileFilter(int n2) {
        this(new ArrayList(n2));
    }

    public AndFileFilter(IOFileFilter ... iOFileFilterArray) {
        this(Objects.requireNonNull(iOFileFilterArray, "fileFilters").length);
        this.addFileFilter(iOFileFilterArray);
    }

    public AndFileFilter(IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        this(2);
        this.addFileFilter(iOFileFilter);
        this.addFileFilter(iOFileFilter2);
    }

    public AndFileFilter(List list) {
        this(new ArrayList(Objects.requireNonNull(list, "fileFilters")));
    }

    @Override
    public boolean accept(File file) {
        return !this.isEmpty() && this.fileFilters.stream().allMatch(iOFileFilter -> iOFileFilter.accept(file));
    }

    @Override
    public boolean accept(File file, String string) {
        return !this.isEmpty() && this.fileFilters.stream().allMatch(iOFileFilter -> iOFileFilter.accept(file, string));
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        return this.isEmpty() ? FileVisitResult.TERMINATE : AndFileFilter.toDefaultFileVisitResult(this.fileFilters.stream().allMatch(iOFileFilter -> iOFileFilter.accept(path, basicFileAttributes) == FileVisitResult.CONTINUE));
    }

    @Override
    public void addFileFilter(IOFileFilter iOFileFilter) {
        this.fileFilters.add(Objects.requireNonNull(iOFileFilter, "fileFilter"));
    }

    public void addFileFilter(IOFileFilter ... iOFileFilterArray) {
        Stream.of(Objects.requireNonNull(iOFileFilterArray, "fileFilters")).forEach(this::addFileFilter);
    }

    @Override
    public List getFileFilters() {
        return Collections.unmodifiableList(this.fileFilters);
    }

    private boolean isEmpty() {
        return this.fileFilters.isEmpty();
    }

    @Override
    public boolean removeFileFilter(IOFileFilter iOFileFilter) {
        return this.fileFilters.remove(iOFileFilter);
    }

    @Override
    public void setFileFilters(List list) {
        this.fileFilters.clear();
        this.fileFilters.addAll(list);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("(");
        this.append(this.fileFilters, stringBuilder);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

