/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class AgeFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -2132740084016138541L;
    private final boolean acceptOlder;
    private final Instant cutoffInstant;

    public AgeFileFilter(Date date) {
        this(date, true);
    }

    public AgeFileFilter(Date date, boolean bl2) {
        this(date.toInstant(), bl2);
    }

    public AgeFileFilter(File file) {
        this(file, true);
    }

    public AgeFileFilter(File file, boolean bl2) {
        this(FileUtils.lastModifiedUnchecked(file), bl2);
    }

    public AgeFileFilter(Instant instant) {
        this(instant, true);
    }

    public AgeFileFilter(Instant instant, boolean bl2) {
        this.acceptOlder = bl2;
        this.cutoffInstant = instant;
    }

    public AgeFileFilter(long l2) {
        this(Instant.ofEpochMilli(l2), true);
    }

    public AgeFileFilter(long l2, boolean bl2) {
        this(Instant.ofEpochMilli(l2), bl2);
    }

    @Override
    public boolean accept(File file) {
        return this.acceptOlder != FileUtils.isFileNewer(file, this.cutoffInstant);
    }

    @Override
    public FileVisitResult accept(Path path, BasicFileAttributes basicFileAttributes) {
        return this.get(() -> this.toFileVisitResult(this.acceptOlder != PathUtils.isNewer(path, this.cutoffInstant, new LinkOption[0])));
    }

    @Override
    public String toString() {
        String string = this.acceptOlder ? "<=" : ">";
        return super.toString() + "(" + string + this.cutoffInstant + ")";
    }
}

