/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file.attribute;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class FileTimes {
    public static final FileTime EPOCH = FileTime.from(Instant.EPOCH);
    static final long WINDOWS_EPOCH_OFFSET = -116444736000000000L;
    private static final long HUNDRED_NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L) / 100L;
    static final long HUNDRED_NANOS_PER_MILLISECOND = TimeUnit.MILLISECONDS.toNanos(1L) / 100L;

    public static FileTime fromUnixTime(long l2) {
        return FileTime.from(l2, TimeUnit.SECONDS);
    }

    public static boolean isUnixTime(FileTime fileTime) {
        return FileTimes.isUnixTime(FileTimes.toUnixTime(fileTime));
    }

    public static boolean isUnixTime(long l2) {
        return Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE;
    }

    public static FileTime minusMillis(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().minusMillis(l2));
    }

    public static FileTime minusNanos(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().minusNanos(l2));
    }

    public static FileTime minusSeconds(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().minusSeconds(l2));
    }

    public static FileTime now() {
        return FileTime.from(Instant.now());
    }

    public static Date ntfsTimeToDate(long l2) {
        long l3 = Math.addExact(l2, -116444736000000000L);
        long l4 = Math.floorDiv(l3, HUNDRED_NANOS_PER_MILLISECOND);
        return new Date(l4);
    }

    public static FileTime ntfsTimeToFileTime(long l2) {
        long l3 = Math.addExact(l2, -116444736000000000L);
        long l4 = Math.floorDiv(l3, HUNDRED_NANOS_PER_SECOND);
        long l5 = Math.floorMod(l3, HUNDRED_NANOS_PER_SECOND) * 100L;
        return FileTime.from(Instant.ofEpochSecond(l4, l5));
    }

    public static FileTime plusMillis(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().plusMillis(l2));
    }

    public static FileTime plusNanos(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().plusNanos(l2));
    }

    public static FileTime plusSeconds(FileTime fileTime, long l2) {
        return FileTime.from(fileTime.toInstant().plusSeconds(l2));
    }

    public static void setLastModifiedTime(Path path) {
        Files.setLastModifiedTime(path, FileTimes.now());
    }

    public static Date toDate(FileTime fileTime) {
        return fileTime != null ? new Date(fileTime.toMillis()) : null;
    }

    public static FileTime toFileTime(Date date) {
        return date != null ? FileTime.fromMillis(date.getTime()) : null;
    }

    public static long toNtfsTime(Date date) {
        long l2 = date.getTime() * HUNDRED_NANOS_PER_MILLISECOND;
        return Math.subtractExact(l2, -116444736000000000L);
    }

    public static long toNtfsTime(FileTime fileTime) {
        Instant instant = fileTime.toInstant();
        long l2 = instant.getEpochSecond() * HUNDRED_NANOS_PER_SECOND + (long)(instant.getNano() / 100);
        return Math.subtractExact(l2, -116444736000000000L);
    }

    public static long toNtfsTime(long l2) {
        long l3 = l2 * HUNDRED_NANOS_PER_MILLISECOND;
        return Math.subtractExact(l3, -116444736000000000L);
    }

    public static long toUnixTime(FileTime fileTime) {
        return fileTime != null ? fileTime.to(TimeUnit.SECONDS) : 0L;
    }

    private FileTimes() {
    }
}

