/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.time.Instant;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.RandomAccessFiles;
import org.apache.commons.io.ThreadUtils;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.CleaningPathVisitor;
import org.apache.commons.io.file.CopyDirectoryVisitor;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.DeleteOption;
import org.apache.commons.io.file.DeletingPathVisitor;
import org.apache.commons.io.file.DirectoryStreamFilter;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils$RelativeSortedPaths;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.file.attribute.FileTimes;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOSupplier;

public final class PathUtils {
    private static final OpenOption[] OPEN_OPTIONS_TRUNCATE = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
    private static final OpenOption[] OPEN_OPTIONS_APPEND = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND};
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];
    public static final DeleteOption[] EMPTY_DELETE_OPTION_ARRAY = new DeleteOption[0];
    public static final FileAttribute[] EMPTY_FILE_ATTRIBUTE_ARRAY = new FileAttribute[0];
    public static final FileVisitOption[] EMPTY_FILE_VISIT_OPTION_ARRAY = new FileVisitOption[0];
    public static final LinkOption[] EMPTY_LINK_OPTION_ARRAY = new LinkOption[0];
    @Deprecated
    public static final LinkOption[] NOFOLLOW_LINK_OPTION_ARRAY = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
    static final LinkOption NULL_LINK_OPTION = null;
    public static final OpenOption[] EMPTY_OPEN_OPTION_ARRAY = new OpenOption[0];
    public static final Path[] EMPTY_PATH_ARRAY = new Path[0];

    private static AccumulatorPathVisitor accumulate(Path path, int n2, FileVisitOption[] fileVisitOptionArray) {
        return (AccumulatorPathVisitor)PathUtils.visitFileTree((FileVisitor)AccumulatorPathVisitor.withLongCounters(), path, PathUtils.toFileVisitOptionSet(fileVisitOptionArray), n2);
    }

    public static Counters$PathCounters cleanDirectory(Path path) {
        return PathUtils.cleanDirectory(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters$PathCounters cleanDirectory(Path path, DeleteOption ... deleteOptionArray) {
        return ((CleaningPathVisitor)PathUtils.visitFileTree((FileVisitor)new CleaningPathVisitor(Counters.longPathCounters(), deleteOptionArray, new String[0]), path)).getPathCounters();
    }

    private static int compareLastModifiedTimeTo(Path path, FileTime fileTime, LinkOption ... linkOptionArray) {
        return PathUtils.getLastModifiedTime(path, linkOptionArray).compareTo(fileTime);
    }

    public static long copy(IOSupplier iOSupplier, Path path, CopyOption ... copyOptionArray) {
        try (InputStream inputStream = (InputStream)iOSupplier.get();){
            long l2 = Files.copy(inputStream, path, copyOptionArray);
            return l2;
        }
    }

    public static Counters$PathCounters copyDirectory(Path path, Path path2, CopyOption ... copyOptionArray) {
        Path path3 = path.toAbsolutePath();
        return ((CopyDirectoryVisitor)PathUtils.visitFileTree((FileVisitor)new CopyDirectoryVisitor(Counters.longPathCounters(), path3, path2, copyOptionArray), path3)).getPathCounters();
    }

    public static Path copyFile(URL uRL, Path path, CopyOption ... copyOptionArray) {
        PathUtils.copy(uRL::openStream, path, copyOptionArray);
        return path;
    }

    public static Path copyFileToDirectory(Path path, Path path2, CopyOption ... copyOptionArray) {
        return Files.copy(path, path2.resolve(path.getFileName()), copyOptionArray);
    }

    public static Path copyFileToDirectory(URL uRL, Path path, CopyOption ... copyOptionArray) {
        Path path2 = path.resolve(FilenameUtils.getName(uRL.getFile()));
        PathUtils.copy(uRL::openStream, path2, copyOptionArray);
        return path2;
    }

    public static Counters$PathCounters countDirectory(Path path) {
        return ((CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)CountingPathVisitor.withLongCounters(), path)).getPathCounters();
    }

    public static Counters$PathCounters countDirectoryAsBigInteger(Path path) {
        return ((CountingPathVisitor)PathUtils.visitFileTree((FileVisitor)CountingPathVisitor.withBigIntegerCounters(), path)).getPathCounters();
    }

    public static Path createParentDirectories(Path path, FileAttribute ... fileAttributeArray) {
        return PathUtils.createParentDirectories(path, LinkOption.NOFOLLOW_LINKS, fileAttributeArray);
    }

    public static Path createParentDirectories(Path path, LinkOption linkOption, FileAttribute ... fileAttributeArray) {
        Path path2 = PathUtils.getParent(path);
        Path path3 = path2 = linkOption == LinkOption.NOFOLLOW_LINKS ? path2 : PathUtils.readIfSymbolicLink(path2);
        if (path2 == null) {
            return null;
        }
        boolean bl2 = linkOption == null ? Files.exists(path2, new LinkOption[0]) : Files.exists(path2, linkOption);
        return bl2 ? path2 : Files.createDirectories(path2, fileAttributeArray);
    }

    public static Path current() {
        return Paths.get(".", new String[0]);
    }

    public static Counters$PathCounters delete(Path path) {
        return PathUtils.delete(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters$PathCounters delete(Path path, DeleteOption ... deleteOptionArray) {
        return Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) ? PathUtils.deleteDirectory(path, deleteOptionArray) : PathUtils.deleteFile(path, deleteOptionArray);
    }

    public static Counters$PathCounters delete(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) {
        return Files.isDirectory(path, linkOptionArray) ? PathUtils.deleteDirectory(path, linkOptionArray, deleteOptionArray) : PathUtils.deleteFile(path, linkOptionArray, deleteOptionArray);
    }

    public static Counters$PathCounters deleteDirectory(Path path) {
        return PathUtils.deleteDirectory(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters$PathCounters deleteDirectory(Path path, DeleteOption ... deleteOptionArray) {
        LinkOption[] linkOptionArray = PathUtils.noFollowLinkOptionArray();
        return (Counters$PathCounters)PathUtils.withPosixFileAttributes(PathUtils.getParent(path), linkOptionArray, PathUtils.overrideReadOnly(deleteOptionArray), posixFileAttributes -> ((DeletingPathVisitor)PathUtils.visitFileTree((FileVisitor)new DeletingPathVisitor(Counters.longPathCounters(), linkOptionArray, deleteOptionArray, new String[0]), path)).getPathCounters());
    }

    public static Counters$PathCounters deleteDirectory(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) {
        return ((DeletingPathVisitor)PathUtils.visitFileTree((FileVisitor)new DeletingPathVisitor(Counters.longPathCounters(), linkOptionArray, deleteOptionArray, new String[0]), path)).getPathCounters();
    }

    public static Counters$PathCounters deleteFile(Path path) {
        return PathUtils.deleteFile(path, EMPTY_DELETE_OPTION_ARRAY);
    }

    public static Counters$PathCounters deleteFile(Path path, DeleteOption ... deleteOptionArray) {
        return PathUtils.deleteFile(path, PathUtils.noFollowLinkOptionArray(), deleteOptionArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counters$PathCounters deleteFile(Path path, LinkOption[] linkOptionArray, DeleteOption ... deleteOptionArray) {
        if (Files.isDirectory(path, linkOptionArray)) {
            throw new NoSuchFileException(path.toString());
        }
        Counters$PathCounters counters$PathCounters = Counters.longPathCounters();
        boolean bl2 = PathUtils.exists(path, linkOptionArray);
        long l2 = bl2 && !Files.isSymbolicLink(path) ? Files.size(path) : 0L;
        try {
            if (Files.deleteIfExists(path)) {
                counters$PathCounters.getFileCounter().increment();
                counters$PathCounters.getByteCounter().add(l2);
                return counters$PathCounters;
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
        Path path2 = PathUtils.getParent(path);
        PosixFileAttributes posixFileAttributes = null;
        try {
            if (PathUtils.overrideReadOnly(deleteOptionArray)) {
                posixFileAttributes = PathUtils.readPosixFileAttributes(path2, linkOptionArray);
                PathUtils.setReadOnly(path, false, linkOptionArray);
            }
            long l3 = l2 = (bl2 = PathUtils.exists(path, linkOptionArray)) && !Files.isSymbolicLink(path) ? Files.size(path) : 0L;
            if (Files.deleteIfExists(path)) {
                counters$PathCounters.getFileCounter().increment();
                counters$PathCounters.getByteCounter().add(l2);
            }
        }
        finally {
            if (posixFileAttributes != null) {
                Files.setPosixFilePermissions(path2, posixFileAttributes.permissions());
            }
        }
        return counters$PathCounters;
    }

    public static void deleteOnExit(Path path) {
        Objects.requireNonNull(path).toFile().deleteOnExit();
    }

    public static boolean directoryAndFileContentEquals(Path path, Path path2) {
        return PathUtils.directoryAndFileContentEquals(path, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryAndFileContentEquals(Path path, Path path2, LinkOption[] linkOptionArray, OpenOption[] openOptionArray, FileVisitOption[] fileVisitOptionArray) {
        if (path == null && path2 == null) {
            return true;
        }
        if (path == null || path2 == null) {
            return false;
        }
        if (PathUtils.notExists(path, new LinkOption[0]) && PathUtils.notExists(path2, new LinkOption[0])) {
            return true;
        }
        PathUtils$RelativeSortedPaths pathUtils$RelativeSortedPaths = new PathUtils$RelativeSortedPaths(path, path2, Integer.MAX_VALUE, linkOptionArray, fileVisitOptionArray);
        if (!pathUtils$RelativeSortedPaths.equals) {
            return false;
        }
        List list = pathUtils$RelativeSortedPaths.relativeFileList1;
        List list2 = pathUtils$RelativeSortedPaths.relativeFileList2;
        for (Path path3 : list) {
            int n2 = Collections.binarySearch(list2, path3);
            if (n2 <= -1) {
                throw new IllegalStateException("Unexpected mismatch.");
            }
            if (PathUtils.fileContentEquals(path.resolve(path3), path2.resolve(path3), linkOptionArray, openOptionArray)) continue;
            return false;
        }
        return true;
    }

    public static boolean directoryContentEquals(Path path, Path path2) {
        return PathUtils.directoryContentEquals(path, path2, Integer.MAX_VALUE, EMPTY_LINK_OPTION_ARRAY, EMPTY_FILE_VISIT_OPTION_ARRAY);
    }

    public static boolean directoryContentEquals(Path path, Path path2, int n2, LinkOption[] linkOptionArray, FileVisitOption[] fileVisitOptionArray) {
        return new PathUtils$RelativeSortedPaths((Path)path, (Path)path2, (int)n2, (LinkOption[])linkOptionArray, (FileVisitOption[])fileVisitOptionArray).equals;
    }

    private static boolean exists(Path path, LinkOption ... linkOptionArray) {
        return path != null && (linkOptionArray != null ? Files.exists(path, linkOptionArray) : Files.exists(path, new LinkOption[0]));
    }

    public static boolean fileContentEquals(Path path, Path path2) {
        return PathUtils.fileContentEquals(path, path2, EMPTY_LINK_OPTION_ARRAY, EMPTY_OPEN_OPTION_ARRAY);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean fileContentEquals(Path path, Path path2, LinkOption[] linkOptionArray, OpenOption[] openOptionArray) {
        if (path == null && path2 == null) {
            return true;
        }
        if (path == null || path2 == null) {
            return false;
        }
        Path path3 = path.normalize();
        Path path4 = path2.normalize();
        boolean bl2 = PathUtils.exists(path3, linkOptionArray);
        if (bl2 != PathUtils.exists(path4, linkOptionArray)) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        if (Files.isDirectory(path3, linkOptionArray)) {
            throw new IOException("Can't compare directories, only files: " + path3);
        }
        if (Files.isDirectory(path4, linkOptionArray)) {
            throw new IOException("Can't compare directories, only files: " + path4);
        }
        if (Files.size(path3) != Files.size(path4)) {
            return false;
        }
        if (path.equals(path2)) {
            return true;
        }
        try (RandomAccessFile randomAccessFile = RandomAccessFileMode.READ_ONLY.create(path.toRealPath(linkOptionArray));){
            boolean bl3;
            block34: {
                RandomAccessFile randomAccessFile2 = RandomAccessFileMode.READ_ONLY.create(path2.toRealPath(linkOptionArray));
                try {
                    bl3 = RandomAccessFiles.contentEquals(randomAccessFile, randomAccessFile2);
                    if (randomAccessFile2 == null) break block34;
                }
                catch (Throwable throwable) {
                    if (randomAccessFile2 != null) {
                        try {
                            randomAccessFile2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                randomAccessFile2.close();
            }
            return bl3;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            try (InputStream inputStream = Files.newInputStream(path3, openOptionArray);){
                boolean bl4;
                block35: {
                    InputStream inputStream2 = Files.newInputStream(path4, openOptionArray);
                    try {
                        bl4 = IOUtils.contentEquals(inputStream, inputStream2);
                        if (inputStream2 == null) break block35;
                    }
                    catch (Throwable throwable) {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    inputStream2.close();
                }
                return bl4;
            }
        }
    }

    public static Path[] filter(PathFilter pathFilter, Path ... pathArray) {
        Objects.requireNonNull(pathFilter, "filter");
        if (pathArray == null) {
            return EMPTY_PATH_ARRAY;
        }
        return ((List)PathUtils.filterPaths(pathFilter, Stream.of(pathArray), Collectors.toList())).toArray(EMPTY_PATH_ARRAY);
    }

    private static Object filterPaths(PathFilter pathFilter, Stream stream, Collector collector) {
        Objects.requireNonNull(pathFilter, "filter");
        Objects.requireNonNull(collector, "collector");
        if (stream == null) {
            return Stream.empty().collect(collector);
        }
        return stream.filter(path -> {
            try {
                return path != null && pathFilter.accept((Path)path, PathUtils.readBasicFileAttributes(path)) == FileVisitResult.CONTINUE;
            }
            catch (IOException iOException) {
                return false;
            }
        }).collect(collector);
    }

    public static List getAclEntryList(Path path) {
        AclFileAttributeView aclFileAttributeView = PathUtils.getAclFileAttributeView(path, new LinkOption[0]);
        return aclFileAttributeView == null ? null : aclFileAttributeView.getAcl();
    }

    public static AclFileAttributeView getAclFileAttributeView(Path path, LinkOption ... linkOptionArray) {
        return Files.getFileAttributeView(path, AclFileAttributeView.class, linkOptionArray);
    }

    public static String getBaseName(Path path) {
        if (path == null) {
            return null;
        }
        Path path2 = path.getFileName();
        return path2 != null ? FilenameUtils.removeExtension(path2.toString()) : null;
    }

    public static DosFileAttributeView getDosFileAttributeView(Path path, LinkOption ... linkOptionArray) {
        return Files.getFileAttributeView(path, DosFileAttributeView.class, linkOptionArray);
    }

    public static String getExtension(Path path) {
        String string = PathUtils.getFileNameString(path);
        return string != null ? FilenameUtils.getExtension(string) : null;
    }

    public static Object getFileName(Path path, Function function) {
        Path path2 = path != null ? path.getFileName() : null;
        return path2 != null ? function.apply(path2) : null;
    }

    public static String getFileNameString(Path path) {
        return (String)PathUtils.getFileName(path, Path::toString);
    }

    public static FileTime getLastModifiedFileTime(File file) {
        return PathUtils.getLastModifiedFileTime(file.toPath(), null, EMPTY_LINK_OPTION_ARRAY);
    }

    public static FileTime getLastModifiedFileTime(Path path, FileTime fileTime, LinkOption ... linkOptionArray) {
        return Files.exists(path, new LinkOption[0]) ? PathUtils.getLastModifiedTime(path, linkOptionArray) : fileTime;
    }

    public static FileTime getLastModifiedFileTime(Path path, LinkOption ... linkOptionArray) {
        return PathUtils.getLastModifiedFileTime(path, null, linkOptionArray);
    }

    public static FileTime getLastModifiedFileTime(URI uRI) {
        return PathUtils.getLastModifiedFileTime(Paths.get(uRI), null, EMPTY_LINK_OPTION_ARRAY);
    }

    public static FileTime getLastModifiedFileTime(URL uRL) {
        return PathUtils.getLastModifiedFileTime(uRL.toURI());
    }

    private static FileTime getLastModifiedTime(Path path, LinkOption ... linkOptionArray) {
        return Files.getLastModifiedTime(Objects.requireNonNull(path, "path"), linkOptionArray);
    }

    private static Path getParent(Path path) {
        return path == null ? null : path.getParent();
    }

    public static PosixFileAttributeView getPosixFileAttributeView(Path path, LinkOption ... linkOptionArray) {
        return Files.getFileAttributeView(path, PosixFileAttributeView.class, linkOptionArray);
    }

    public static Path getTempDirectory() {
        return Paths.get(FileUtils.getTempDirectoryPath(), new String[0]);
    }

    public static boolean isDirectory(Path path, LinkOption ... linkOptionArray) {
        return path != null && Files.isDirectory(path, linkOptionArray);
    }

    public static boolean isEmpty(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) ? PathUtils.isEmptyDirectory(path) : PathUtils.isEmptyFile(path);
    }

    public static boolean isEmptyDirectory(Path path) {
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            boolean bl2 = !directoryStream.iterator().hasNext();
            return bl2;
        }
    }

    public static boolean isEmptyFile(Path path) {
        return Files.size(path) <= 0L;
    }

    public static boolean isNewer(Path path, ChronoZonedDateTime chronoZonedDateTime, LinkOption ... linkOptionArray) {
        Objects.requireNonNull(chronoZonedDateTime, "czdt");
        return PathUtils.isNewer(path, chronoZonedDateTime.toInstant(), linkOptionArray);
    }

    public static boolean isNewer(Path path, FileTime fileTime, LinkOption ... linkOptionArray) {
        if (PathUtils.notExists(path, new LinkOption[0])) {
            return false;
        }
        return PathUtils.compareLastModifiedTimeTo(path, fileTime, linkOptionArray) > 0;
    }

    public static boolean isNewer(Path path, Instant instant, LinkOption ... linkOptionArray) {
        return PathUtils.isNewer(path, FileTime.from(instant), linkOptionArray);
    }

    public static boolean isNewer(Path path, long l2, LinkOption ... linkOptionArray) {
        return PathUtils.isNewer(path, FileTime.fromMillis(l2), linkOptionArray);
    }

    public static boolean isNewer(Path path, Path path2) {
        return PathUtils.isNewer(path, PathUtils.getLastModifiedTime(path2, new LinkOption[0]), new LinkOption[0]);
    }

    public static boolean isOlder(Path path, FileTime fileTime, LinkOption ... linkOptionArray) {
        if (PathUtils.notExists(path, new LinkOption[0])) {
            return false;
        }
        return PathUtils.compareLastModifiedTimeTo(path, fileTime, linkOptionArray) < 0;
    }

    public static boolean isOlder(Path path, Instant instant, LinkOption ... linkOptionArray) {
        return PathUtils.isOlder(path, FileTime.from(instant), linkOptionArray);
    }

    public static boolean isOlder(Path path, long l2, LinkOption ... linkOptionArray) {
        return PathUtils.isOlder(path, FileTime.fromMillis(l2), linkOptionArray);
    }

    public static boolean isOlder(Path path, Path path2) {
        return PathUtils.isOlder(path, PathUtils.getLastModifiedTime(path2, new LinkOption[0]), new LinkOption[0]);
    }

    public static boolean isPosix(Path path, LinkOption ... linkOptionArray) {
        return PathUtils.exists(path, linkOptionArray) && PathUtils.readPosixFileAttributes(path, linkOptionArray) != null;
    }

    public static boolean isRegularFile(Path path, LinkOption ... linkOptionArray) {
        return path != null && Files.isRegularFile(path, linkOptionArray);
    }

    public static DirectoryStream newDirectoryStream(Path path, PathFilter pathFilter) {
        return Files.newDirectoryStream(path, new DirectoryStreamFilter(pathFilter));
    }

    public static OutputStream newOutputStream(Path path, boolean bl2) {
        return PathUtils.newOutputStream(path, EMPTY_LINK_OPTION_ARRAY, bl2 ? OPEN_OPTIONS_APPEND : OPEN_OPTIONS_TRUNCATE);
    }

    static OutputStream newOutputStream(Path path, LinkOption[] linkOptionArray, OpenOption ... openOptionArray) {
        if (!PathUtils.exists(path, linkOptionArray)) {
            PathUtils.createParentDirectories(path, linkOptionArray != null && linkOptionArray.length > 0 ? linkOptionArray[0] : NULL_LINK_OPTION, new FileAttribute[0]);
        }
        ArrayList<OpenOption> arrayList = new ArrayList<OpenOption>(Arrays.asList(openOptionArray != null ? openOptionArray : EMPTY_OPEN_OPTION_ARRAY));
        arrayList.addAll(Arrays.asList(linkOptionArray != null ? linkOptionArray : EMPTY_LINK_OPTION_ARRAY));
        return Files.newOutputStream(path, arrayList.toArray(EMPTY_OPEN_OPTION_ARRAY));
    }

    public static LinkOption[] noFollowLinkOptionArray() {
        return (LinkOption[])NOFOLLOW_LINK_OPTION_ARRAY.clone();
    }

    private static boolean notExists(Path path, LinkOption ... linkOptionArray) {
        return Files.notExists(Objects.requireNonNull(path, "path"), linkOptionArray);
    }

    private static boolean overrideReadOnly(DeleteOption ... deleteOptionArray) {
        if (deleteOptionArray == null) {
            return false;
        }
        return Stream.of(deleteOptionArray).anyMatch(deleteOption -> deleteOption == StandardDeleteOption.OVERRIDE_READ_ONLY);
    }

    public static BasicFileAttributes readAttributes(Path path, Class clazz, LinkOption ... linkOptionArray) {
        try {
            return path == null ? null : (BasicFileAttributes)Files.readAttributes(path, clazz, linkOptionArray);
        }
        catch (IOException | UnsupportedOperationException exception) {
            return null;
        }
    }

    public static BasicFileAttributes readBasicFileAttributes(Path path) {
        return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
    }

    public static BasicFileAttributes readBasicFileAttributes(Path path, LinkOption ... linkOptionArray) {
        return PathUtils.readAttributes(path, BasicFileAttributes.class, linkOptionArray);
    }

    @Deprecated
    public static BasicFileAttributes readBasicFileAttributesUnchecked(Path path) {
        return PathUtils.readBasicFileAttributes(path, EMPTY_LINK_OPTION_ARRAY);
    }

    public static DosFileAttributes readDosFileAttributes(Path path, LinkOption ... linkOptionArray) {
        return (DosFileAttributes)PathUtils.readAttributes(path, DosFileAttributes.class, linkOptionArray);
    }

    private static Path readIfSymbolicLink(Path path) {
        return path != null ? (Files.isSymbolicLink(path) ? Files.readSymbolicLink(path) : path) : null;
    }

    public static BasicFileAttributes readOsFileAttributes(Path path, LinkOption ... linkOptionArray) {
        PosixFileAttributes posixFileAttributes = PathUtils.readPosixFileAttributes(path, linkOptionArray);
        return posixFileAttributes != null ? posixFileAttributes : PathUtils.readDosFileAttributes(path, linkOptionArray);
    }

    public static PosixFileAttributes readPosixFileAttributes(Path path, LinkOption ... linkOptionArray) {
        return (PosixFileAttributes)PathUtils.readAttributes(path, PosixFileAttributes.class, linkOptionArray);
    }

    public static String readString(Path path, Charset charset) {
        return new String(Files.readAllBytes(path), Charsets.toCharset(charset));
    }

    static List relativize(Collection collection, Path path, boolean bl2, Comparator comparator) {
        Stream<Path> stream = collection.stream().map(path::relativize);
        if (bl2) {
            stream = comparator == null ? stream.sorted() : stream.sorted(comparator);
        }
        return stream.collect(Collectors.toList());
    }

    private static Path requireExists(Path path, String string, LinkOption ... linkOptionArray) {
        Objects.requireNonNull(path, string);
        if (!PathUtils.exists(path, linkOptionArray)) {
            throw new IllegalArgumentException("File system element for parameter '" + string + "' does not exist: '" + path + "'");
        }
        return path;
    }

    private static boolean setDosReadOnly(Path path, boolean bl2, LinkOption ... linkOptionArray) {
        DosFileAttributeView dosFileAttributeView = PathUtils.getDosFileAttributeView(path, linkOptionArray);
        if (dosFileAttributeView != null) {
            dosFileAttributeView.setReadOnly(bl2);
            return true;
        }
        return false;
    }

    public static void setLastModifiedTime(Path path, Path path2) {
        Objects.requireNonNull(path, "sourceFile");
        Files.setLastModifiedTime(path2, PathUtils.getLastModifiedTime(path, new LinkOption[0]));
    }

    private static boolean setPosixDeletePermissions(Path path, boolean bl2, LinkOption ... linkOptionArray) {
        return PathUtils.setPosixPermissions(path, bl2, Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), linkOptionArray);
    }

    private static boolean setPosixPermissions(Path path, boolean bl2, List list, LinkOption ... linkOptionArray) {
        if (path != null) {
            Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, linkOptionArray);
            HashSet<PosixFilePermission> hashSet = new HashSet<PosixFilePermission>(set);
            if (bl2) {
                hashSet.addAll(list);
            } else {
                hashSet.removeAll(list);
            }
            if (!hashSet.equals(set)) {
                Files.setPosixFilePermissions(path, hashSet);
            }
            return true;
        }
        return false;
    }

    private static void setPosixReadOnlyFile(Path path, boolean bl2, LinkOption ... linkOptionArray) {
        Set<PosixFilePermission> set = Files.getPosixFilePermissions(path, linkOptionArray);
        List<PosixFilePermission> list = Arrays.asList(PosixFilePermission.OWNER_READ);
        List<PosixFilePermission> list2 = Arrays.asList(PosixFilePermission.OWNER_WRITE);
        if (bl2) {
            set.addAll(list);
            set.removeAll(list2);
        } else {
            set.addAll(list);
            set.addAll(list2);
        }
        Files.setPosixFilePermissions(path, set);
    }

    public static Path setReadOnly(Path path, boolean bl2, LinkOption ... linkOptionArray) {
        try {
            if (PathUtils.setDosReadOnly(path, bl2, linkOptionArray)) {
                return path;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path path2 = PathUtils.getParent(path);
        if (!PathUtils.isPosix(path2, linkOptionArray)) {
            throw new IOException(String.format("DOS or POSIX file operations not available for '%s', linkOptions %s", path, Arrays.toString(linkOptionArray)));
        }
        if (bl2) {
            PathUtils.setPosixReadOnlyFile(path, bl2, linkOptionArray);
            PathUtils.setPosixDeletePermissions(path2, false, linkOptionArray);
        } else {
            PathUtils.setPosixDeletePermissions(path2, true, linkOptionArray);
        }
        return path;
    }

    public static long sizeOf(Path path) {
        PathUtils.requireExists(path, "path", new LinkOption[0]);
        return Files.isDirectory(path, new LinkOption[0]) ? PathUtils.sizeOfDirectory(path) : Files.size(path);
    }

    public static BigInteger sizeOfAsBigInteger(Path path) {
        PathUtils.requireExists(path, "path", new LinkOption[0]);
        return Files.isDirectory(path, new LinkOption[0]) ? PathUtils.sizeOfDirectoryAsBigInteger(path) : BigInteger.valueOf(Files.size(path));
    }

    public static long sizeOfDirectory(Path path) {
        return PathUtils.countDirectory(path).getByteCounter().getLong();
    }

    public static BigInteger sizeOfDirectoryAsBigInteger(Path path) {
        return PathUtils.countDirectoryAsBigInteger(path).getByteCounter().getBigInteger();
    }

    static Set toFileVisitOptionSet(FileVisitOption ... fileVisitOptionArray) {
        return fileVisitOptionArray == null ? EnumSet.noneOf(FileVisitOption.class) : Stream.of(fileVisitOptionArray).collect(Collectors.toSet());
    }

    public static Path touch(Path path) {
        Objects.requireNonNull(path, "file");
        if (!Files.exists(path, new LinkOption[0])) {
            PathUtils.createParentDirectories(path, new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        } else {
            FileTimes.setLastModifiedTime(path);
        }
        return path;
    }

    public static FileVisitor visitFileTree(FileVisitor fileVisitor, Path path) {
        Files.walkFileTree(path, fileVisitor);
        return fileVisitor;
    }

    public static FileVisitor visitFileTree(FileVisitor fileVisitor, Path path, Set set, int n2) {
        Files.walkFileTree(path, set, n2, fileVisitor);
        return fileVisitor;
    }

    public static FileVisitor visitFileTree(FileVisitor fileVisitor, String string, String ... stringArray) {
        return PathUtils.visitFileTree(fileVisitor, Paths.get(string, stringArray));
    }

    public static FileVisitor visitFileTree(FileVisitor fileVisitor, URI uRI) {
        return PathUtils.visitFileTree(fileVisitor, Paths.get(uRI));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitFor(Path path, Duration duration, LinkOption ... linkOptionArray) {
        Objects.requireNonNull(path, "file");
        Instant instant = Instant.now().plus(duration);
        boolean bl2 = false;
        long l2 = 100L;
        try {
            while (!PathUtils.exists(path, linkOptionArray)) {
                Instant instant2 = Instant.now();
                if (instant2.isAfter(instant)) {
                    boolean bl3 = false;
                    return bl3;
                }
                try {
                    ThreadUtils.sleep(Duration.ofMillis(Math.min(100L, instant.minusMillis(instant2.toEpochMilli()).toEpochMilli())));
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
                catch (Exception exception) {
                    break;
                }
            }
        }
        finally {
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
        return PathUtils.exists(path, linkOptionArray);
    }

    public static Stream walk(Path path2, PathFilter pathFilter, int n2, boolean bl2, FileVisitOption ... fileVisitOptionArray) {
        return Files.walk(path2, n2, fileVisitOptionArray).filter(path -> pathFilter.accept((Path)path, bl2 ? PathUtils.readBasicFileAttributesUnchecked(path) : null) == FileVisitResult.CONTINUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object withPosixFileAttributes(Path path, LinkOption[] linkOptionArray, boolean bl2, IOFunction iOFunction) {
        PosixFileAttributes posixFileAttributes = bl2 ? PathUtils.readPosixFileAttributes(path, linkOptionArray) : null;
        try {
            Object object = iOFunction.apply(posixFileAttributes);
            return object;
        }
        finally {
            if (posixFileAttributes != null && path != null && Files.exists(path, linkOptionArray)) {
                Files.setPosixFilePermissions(path, posixFileAttributes.permissions());
            }
        }
    }

    public static Path writeString(Path path, CharSequence charSequence, Charset charset, OpenOption ... openOptionArray) {
        Objects.requireNonNull(path, "path");
        Objects.requireNonNull(charSequence, "charSequence");
        Files.write(path, String.valueOf(charSequence).getBytes(Charsets.toCharset(charset)), openOptionArray);
        return path;
    }

    private PathUtils() {
    }

    static /* synthetic */ AccumulatorPathVisitor access$000(Path path, int n2, FileVisitOption[] fileVisitOptionArray) {
        return PathUtils.accumulate(path, n2, fileVisitOptionArray);
    }
}

