/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.SimplePathVisitor;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SymbolicLinkFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.function.IOBiFunction;

public class CountingPathVisitor
extends SimplePathVisitor {
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Counters$PathCounters pathCounters;
    private final PathFilter fileFilter;
    private final PathFilter dirFilter;

    static IOFileFilter defaultDirFilter() {
        return TrueFileFilter.INSTANCE;
    }

    static IOFileFilter defaultFileFilter() {
        return new SymbolicLinkFileFilter(FileVisitResult.TERMINATE, FileVisitResult.CONTINUE);
    }

    public static CountingPathVisitor withBigIntegerCounters() {
        return new CountingPathVisitor(Counters.bigIntegerPathCounters());
    }

    public static CountingPathVisitor withLongCounters() {
        return new CountingPathVisitor(Counters.longPathCounters());
    }

    public CountingPathVisitor(Counters$PathCounters counters$PathCounters) {
        this(counters$PathCounters, CountingPathVisitor.defaultFileFilter(), CountingPathVisitor.defaultDirFilter());
    }

    public CountingPathVisitor(Counters$PathCounters counters$PathCounters, PathFilter pathFilter, PathFilter pathFilter2) {
        this.pathCounters = Objects.requireNonNull(counters$PathCounters, "pathCounter");
        this.fileFilter = Objects.requireNonNull(pathFilter, "fileFilter");
        this.dirFilter = Objects.requireNonNull(pathFilter2, "dirFilter");
    }

    public CountingPathVisitor(Counters$PathCounters counters$PathCounters, PathFilter pathFilter, PathFilter pathFilter2, IOBiFunction iOBiFunction) {
        super(iOBiFunction);
        this.pathCounters = Objects.requireNonNull(counters$PathCounters, "pathCounter");
        this.fileFilter = Objects.requireNonNull(pathFilter, "fileFilter");
        this.dirFilter = Objects.requireNonNull(pathFilter2, "dirFilter");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CountingPathVisitor)) {
            return false;
        }
        CountingPathVisitor countingPathVisitor = (CountingPathVisitor)object;
        return Objects.equals(this.pathCounters, countingPathVisitor.pathCounters);
    }

    public Counters$PathCounters getPathCounters() {
        return this.pathCounters;
    }

    public int hashCode() {
        return Objects.hash(this.pathCounters);
    }

    public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
        this.updateDirCounter(path, iOException);
        return FileVisitResult.CONTINUE;
    }

    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        FileVisitResult fileVisitResult = this.dirFilter.accept(path, basicFileAttributes);
        return fileVisitResult != FileVisitResult.CONTINUE ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
    }

    public String toString() {
        return this.pathCounters.toString();
    }

    protected void updateDirCounter(Path path, IOException iOException) {
        this.pathCounters.getDirectoryCounter().increment();
    }

    protected void updateFileCounters(Path path, BasicFileAttributes basicFileAttributes) {
        this.pathCounters.getFileCounter().increment();
        this.pathCounters.getByteCounter().add(basicFileAttributes.size());
    }

    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        if (Files.exists(path, new LinkOption[0]) && this.fileFilter.accept(path, basicFileAttributes) == FileVisitResult.CONTINUE) {
            this.updateFileCounters(path, basicFileAttributes);
        }
        return FileVisitResult.CONTINUE;
    }
}

