/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils;

public class CopyDirectoryVisitor
extends CountingPathVisitor {
    private final CopyOption[] copyOptions;
    private final Path sourceDirectory;
    private final Path targetDirectory;

    private static CopyOption[] toCopyOption(CopyOption ... copyOptionArray) {
        return copyOptionArray == null ? PathUtils.EMPTY_COPY_OPTIONS : (CopyOption[])copyOptionArray.clone();
    }

    public CopyDirectoryVisitor(Counters$PathCounters counters$PathCounters, Path path, Path path2, CopyOption ... copyOptionArray) {
        super(counters$PathCounters);
        this.sourceDirectory = path;
        this.targetDirectory = path2;
        this.copyOptions = CopyDirectoryVisitor.toCopyOption(copyOptionArray);
    }

    public CopyDirectoryVisitor(Counters$PathCounters counters$PathCounters, PathFilter pathFilter, PathFilter pathFilter2, Path path, Path path2, CopyOption ... copyOptionArray) {
        super(counters$PathCounters, pathFilter, pathFilter2);
        this.sourceDirectory = path;
        this.targetDirectory = path2;
        this.copyOptions = CopyDirectoryVisitor.toCopyOption(copyOptionArray);
    }

    protected void copy(Path path, Path path2) {
        Files.copy(path, path2, this.copyOptions);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CopyDirectoryVisitor copyDirectoryVisitor = (CopyDirectoryVisitor)object;
        return Arrays.equals(this.copyOptions, copyDirectoryVisitor.copyOptions) && Objects.equals(this.sourceDirectory, copyDirectoryVisitor.sourceDirectory) && Objects.equals(this.targetDirectory, copyDirectoryVisitor.targetDirectory);
    }

    public CopyOption[] getCopyOptions() {
        return (CopyOption[])this.copyOptions.clone();
    }

    public Path getSourceDirectory() {
        return this.sourceDirectory;
    }

    public Path getTargetDirectory() {
        return this.targetDirectory;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + Arrays.hashCode(this.copyOptions);
        n3 = 31 * n3 + Objects.hash(this.sourceDirectory, this.targetDirectory);
        return n3;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
        Path path2 = this.resolveRelativeAsString(path);
        if (Files.notExists(path2, new LinkOption[0])) {
            Files.createDirectory(path2, new FileAttribute[0]);
        }
        return super.preVisitDirectory(path, basicFileAttributes);
    }

    private Path resolveRelativeAsString(Path path) {
        return this.targetDirectory.resolve(this.sourceDirectory.relativize(path).toString());
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
        Path path2 = this.resolveRelativeAsString(path);
        this.copy(path, path2);
        return super.visitFile(path2, basicFileAttributes);
    }
}

