/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.CountingPathVisitor;
import org.apache.commons.io.file.PathFilter;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.function.IOBiFunction;

public class AccumulatorPathVisitor
extends CountingPathVisitor {
    private final List dirList = new ArrayList();
    private final List fileList = new ArrayList();

    public static AccumulatorPathVisitor withBigIntegerCounters() {
        return new AccumulatorPathVisitor(Counters.bigIntegerPathCounters());
    }

    public static AccumulatorPathVisitor withBigIntegerCounters(PathFilter pathFilter, PathFilter pathFilter2) {
        return new AccumulatorPathVisitor(Counters.bigIntegerPathCounters(), pathFilter, pathFilter2);
    }

    public static AccumulatorPathVisitor withLongCounters() {
        return new AccumulatorPathVisitor(Counters.longPathCounters());
    }

    public static AccumulatorPathVisitor withLongCounters(PathFilter pathFilter, PathFilter pathFilter2) {
        return new AccumulatorPathVisitor(Counters.longPathCounters(), pathFilter, pathFilter2);
    }

    public AccumulatorPathVisitor() {
        super(Counters.noopPathCounters());
    }

    public AccumulatorPathVisitor(Counters$PathCounters counters$PathCounters) {
        super(counters$PathCounters);
    }

    public AccumulatorPathVisitor(Counters$PathCounters counters$PathCounters, PathFilter pathFilter, PathFilter pathFilter2) {
        super(counters$PathCounters, pathFilter, pathFilter2);
    }

    public AccumulatorPathVisitor(Counters$PathCounters counters$PathCounters, PathFilter pathFilter, PathFilter pathFilter2, IOBiFunction iOBiFunction) {
        super(counters$PathCounters, pathFilter, pathFilter2, iOBiFunction);
    }

    private void add(List list, Path path) {
        list.add(path.normalize());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof AccumulatorPathVisitor)) {
            return false;
        }
        AccumulatorPathVisitor accumulatorPathVisitor = (AccumulatorPathVisitor)object;
        return Objects.equals(this.dirList, accumulatorPathVisitor.dirList) && Objects.equals(this.fileList, accumulatorPathVisitor.fileList);
    }

    public List getDirList() {
        return new ArrayList(this.dirList);
    }

    public List getFileList() {
        return new ArrayList(this.fileList);
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + Objects.hash(this.dirList, this.fileList);
        return n3;
    }

    public List relativizeDirectories(Path path, boolean bl2, Comparator comparator) {
        return PathUtils.relativize(this.getDirList(), path, bl2, comparator);
    }

    public List relativizeFiles(Path path, boolean bl2, Comparator comparator) {
        return PathUtils.relativize(this.getFileList(), path, bl2, comparator);
    }

    @Override
    protected void updateDirCounter(Path path, IOException iOException) {
        super.updateDirCounter(path, iOException);
        this.add(this.dirList, path);
    }

    @Override
    protected void updateFileCounters(Path path, BasicFileAttributes basicFileAttributes) {
        super.updateFileCounters(path, basicFileAttributes);
        this.add(this.fileList, path);
    }
}

