/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.comparator;

import java.io.File;
import java.io.Serializable;
import java.util.Comparator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.comparator.AbstractFileComparator;

public class CompositeFileComparator
extends AbstractFileComparator
implements Serializable {
    private static final Comparator[] EMPTY_COMPARATOR_ARRAY = new Comparator[0];
    private static final long serialVersionUID = -2224170307287243428L;
    private final Comparator[] delegates;

    public CompositeFileComparator(Comparator ... comparatorArray) {
        this.delegates = comparatorArray == null ? this.emptyArray() : (Comparator[])comparatorArray.clone();
    }

    public CompositeFileComparator(Iterable iterable) {
        this.delegates = iterable == null ? this.emptyArray() : (Comparator[])StreamSupport.stream(iterable.spliterator(), false).toArray(Comparator[]::new);
    }

    public int compare(File file, File file2) {
        return Stream.of(this.delegates).map(comparator -> comparator.compare(file, file2)).filter(n2 -> n2 != 0).findFirst().orElse(0);
    }

    private Comparator[] emptyArray() {
        return EMPTY_COMPARATOR_ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append('{');
        for (int i2 = 0; i2 < this.delegates.length; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.delegates[i2]);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

