/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.IntUnaryOperator;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.build.AbstractOriginSupplier;
import org.apache.commons.io.file.PathUtils;

public abstract class AbstractStreamBuilder
extends AbstractOriginSupplier {
    private static final int DEFAULT_MAX_VALUE = Integer.MAX_VALUE;
    private static final OpenOption[] DEFAULT_OPEN_OPTIONS = PathUtils.EMPTY_OPEN_OPTION_ARRAY;
    private int bufferSize = 8192;
    private int bufferSizeDefault = 8192;
    private int bufferSizeMax = Integer.MAX_VALUE;
    private Charset charset = Charset.defaultCharset();
    private Charset charsetDefault = Charset.defaultCharset();
    private OpenOption[] openOptions = DEFAULT_OPEN_OPTIONS;
    private final IntUnaryOperator defaultSizeChecker;
    private IntUnaryOperator bufferSizeChecker = this.defaultSizeChecker = n2 -> n2 > this.bufferSizeMax ? this.throwIae(n2, this.bufferSizeMax) : n2;

    private int checkBufferSize(int n2) {
        return this.bufferSizeChecker.applyAsInt(n2);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getBufferSizeDefault() {
        return this.bufferSizeDefault;
    }

    public CharSequence getCharSequence() {
        return this.checkOrigin().getCharSequence(this.getCharset());
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Charset getCharsetDefault() {
        return this.charsetDefault;
    }

    public File getFile() {
        return this.checkOrigin().getFile();
    }

    public InputStream getInputStream() {
        return this.checkOrigin().getInputStream(this.getOpenOptions());
    }

    public OpenOption[] getOpenOptions() {
        return this.openOptions;
    }

    public OutputStream getOutputStream() {
        return this.checkOrigin().getOutputStream(this.getOpenOptions());
    }

    public Path getPath() {
        return this.checkOrigin().getPath();
    }

    public RandomAccessFile getRandomAccessFile() {
        return this.checkOrigin().getRandomAccessFile(this.getOpenOptions());
    }

    public Reader getReader() {
        return this.checkOrigin().getReader(this.getCharset());
    }

    public Writer getWriter() {
        return this.checkOrigin().getWriter(this.getCharset(), this.getOpenOptions());
    }

    public AbstractStreamBuilder setBufferSize(int n2) {
        this.bufferSize = this.checkBufferSize(n2 > 0 ? n2 : this.bufferSizeDefault);
        return (AbstractStreamBuilder)this.asThis();
    }

    public AbstractStreamBuilder setBufferSize(Integer n2) {
        this.setBufferSize(n2 != null ? n2 : this.bufferSizeDefault);
        return (AbstractStreamBuilder)this.asThis();
    }

    public AbstractStreamBuilder setBufferSizeChecker(IntUnaryOperator intUnaryOperator) {
        this.bufferSizeChecker = intUnaryOperator != null ? intUnaryOperator : this.defaultSizeChecker;
        return (AbstractStreamBuilder)this.asThis();
    }

    protected AbstractStreamBuilder setBufferSizeDefault(int n2) {
        this.bufferSizeDefault = n2;
        return (AbstractStreamBuilder)this.asThis();
    }

    public AbstractStreamBuilder setBufferSizeMax(int n2) {
        this.bufferSizeMax = n2 > 0 ? n2 : Integer.MAX_VALUE;
        return (AbstractStreamBuilder)this.asThis();
    }

    public AbstractStreamBuilder setCharset(Charset charset) {
        this.charset = Charsets.toCharset(charset, this.charsetDefault);
        return (AbstractStreamBuilder)this.asThis();
    }

    public AbstractStreamBuilder setCharset(String string) {
        return this.setCharset(Charsets.toCharset(string, this.charsetDefault));
    }

    protected AbstractStreamBuilder setCharsetDefault(Charset charset) {
        this.charsetDefault = charset;
        return (AbstractStreamBuilder)this.asThis();
    }

    public AbstractStreamBuilder setOpenOptions(OpenOption ... openOptionArray) {
        this.openOptions = openOptionArray != null ? openOptionArray : DEFAULT_OPEN_OPTIONS;
        return (AbstractStreamBuilder)this.asThis();
    }

    private int throwIae(int n2, int n3) {
        throw new IllegalArgumentException(String.format("Request %,d exceeds maximum %,d", n2, n3));
    }
}

