/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.IORandomAccessFile;
import org.apache.commons.io.build.AbstractOrigin;
import org.apache.commons.io.build.AbstractOrigin$ByteArrayOrigin;
import org.apache.commons.io.build.AbstractOrigin$CharSequenceOrigin;
import org.apache.commons.io.build.AbstractOrigin$FileOrigin;
import org.apache.commons.io.build.AbstractOrigin$IORandomAccessFileOrigin;
import org.apache.commons.io.build.AbstractOrigin$InputStreamOrigin;
import org.apache.commons.io.build.AbstractOrigin$OutputStreamOrigin;
import org.apache.commons.io.build.AbstractOrigin$PathOrigin;
import org.apache.commons.io.build.AbstractOrigin$RandomAccessFileOrigin;
import org.apache.commons.io.build.AbstractOrigin$ReaderOrigin;
import org.apache.commons.io.build.AbstractOrigin$URIOrigin;
import org.apache.commons.io.build.AbstractOrigin$WriterOrigin;
import org.apache.commons.io.build.AbstractSupplier;

public abstract class AbstractOriginSupplier
extends AbstractSupplier {
    private AbstractOrigin origin;

    protected static AbstractOrigin$ByteArrayOrigin newByteArrayOrigin(byte[] byArray) {
        return new AbstractOrigin$ByteArrayOrigin(byArray);
    }

    protected static AbstractOrigin$CharSequenceOrigin newCharSequenceOrigin(CharSequence charSequence) {
        return new AbstractOrigin$CharSequenceOrigin(charSequence);
    }

    protected static AbstractOrigin$FileOrigin newFileOrigin(File file) {
        return new AbstractOrigin$FileOrigin(file);
    }

    protected static AbstractOrigin$FileOrigin newFileOrigin(String string) {
        return new AbstractOrigin$FileOrigin(new File(string));
    }

    protected static AbstractOrigin$InputStreamOrigin newInputStreamOrigin(InputStream inputStream) {
        return new AbstractOrigin$InputStreamOrigin(inputStream);
    }

    protected static AbstractOrigin$OutputStreamOrigin newOutputStreamOrigin(OutputStream outputStream) {
        return new AbstractOrigin$OutputStreamOrigin(outputStream);
    }

    protected static AbstractOrigin$PathOrigin newPathOrigin(Path path) {
        return new AbstractOrigin$PathOrigin(path);
    }

    protected static AbstractOrigin$PathOrigin newPathOrigin(String string) {
        return new AbstractOrigin$PathOrigin(Paths.get(string, new String[0]));
    }

    protected static AbstractOrigin$IORandomAccessFileOrigin newRandomAccessFileOrigin(IORandomAccessFile iORandomAccessFile) {
        return new AbstractOrigin$IORandomAccessFileOrigin(iORandomAccessFile);
    }

    protected static AbstractOrigin$RandomAccessFileOrigin newRandomAccessFileOrigin(RandomAccessFile randomAccessFile) {
        return new AbstractOrigin$RandomAccessFileOrigin(randomAccessFile);
    }

    protected static AbstractOrigin$ReaderOrigin newReaderOrigin(Reader reader) {
        return new AbstractOrigin$ReaderOrigin(reader);
    }

    protected static AbstractOrigin$URIOrigin newURIOrigin(URI uRI) {
        return new AbstractOrigin$URIOrigin(uRI);
    }

    protected static AbstractOrigin$WriterOrigin newWriterOrigin(Writer writer) {
        return new AbstractOrigin$WriterOrigin(writer);
    }

    protected AbstractOrigin checkOrigin() {
        if (this.origin == null) {
            throw new IllegalStateException("origin == null");
        }
        return this.origin;
    }

    protected AbstractOrigin getOrigin() {
        return this.origin;
    }

    protected boolean hasOrigin() {
        return this.origin != null;
    }

    public AbstractOriginSupplier setByteArray(byte[] byArray) {
        return this.setOrigin(AbstractOriginSupplier.newByteArrayOrigin(byArray));
    }

    public AbstractOriginSupplier setCharSequence(CharSequence charSequence) {
        return this.setOrigin(AbstractOriginSupplier.newCharSequenceOrigin(charSequence));
    }

    public AbstractOriginSupplier setFile(File file) {
        return this.setOrigin(AbstractOriginSupplier.newFileOrigin(file));
    }

    public AbstractOriginSupplier setFile(String string) {
        return this.setOrigin(AbstractOriginSupplier.newFileOrigin(string));
    }

    public AbstractOriginSupplier setInputStream(InputStream inputStream) {
        return this.setOrigin(AbstractOriginSupplier.newInputStreamOrigin(inputStream));
    }

    protected AbstractOriginSupplier setOrigin(AbstractOrigin abstractOrigin) {
        this.origin = abstractOrigin;
        return (AbstractOriginSupplier)this.asThis();
    }

    public AbstractOriginSupplier setOutputStream(OutputStream outputStream) {
        return this.setOrigin(AbstractOriginSupplier.newOutputStreamOrigin(outputStream));
    }

    public AbstractOriginSupplier setPath(Path path) {
        return this.setOrigin(AbstractOriginSupplier.newPathOrigin(path));
    }

    public AbstractOriginSupplier setPath(String string) {
        return this.setOrigin(AbstractOriginSupplier.newPathOrigin(string));
    }

    public AbstractOriginSupplier setRandomAccessFile(IORandomAccessFile iORandomAccessFile) {
        return this.setOrigin(AbstractOriginSupplier.newRandomAccessFileOrigin(iORandomAccessFile));
    }

    public AbstractOriginSupplier setRandomAccessFile(RandomAccessFile randomAccessFile) {
        return this.setOrigin(AbstractOriginSupplier.newRandomAccessFileOrigin(randomAccessFile));
    }

    public AbstractOriginSupplier setReader(Reader reader) {
        return this.setOrigin(AbstractOriginSupplier.newReaderOrigin(reader));
    }

    public AbstractOriginSupplier setURI(URI uRI) {
        return this.setOrigin(AbstractOriginSupplier.newURIOrigin(uRI));
    }

    public AbstractOriginSupplier setWriter(Writer writer) {
        return this.setOrigin(AbstractOriginSupplier.newWriterOrigin(writer));
    }
}

