/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.RandomAccessFileMode;
import org.apache.commons.io.build.AbstractSupplier;

public abstract class AbstractOrigin
extends AbstractSupplier {
    final Object origin;

    protected AbstractOrigin(Object object) {
        this.origin = Objects.requireNonNull(object, "origin");
    }

    @Override
    public Object get() {
        return this.origin;
    }

    public byte[] getByteArray() {
        return Files.readAllBytes(this.getPath());
    }

    public byte[] getByteArray(long l2, int n2) {
        byte[] byArray = this.getByteArray();
        int n3 = Math.toIntExact(l2);
        if (n3 < 0 || n2 < 0 || n3 + n2 < 0 || n3 + n2 > byArray.length) {
            throw new IllegalArgumentException("Couldn't read array (start: " + n3 + ", length: " + n2 + ", data length: " + byArray.length + ").");
        }
        return Arrays.copyOfRange(byArray, n3, n3 + n2);
    }

    public CharSequence getCharSequence(Charset charset) {
        return new String(this.getByteArray(), charset);
    }

    public File getFile() {
        throw new UnsupportedOperationException(String.format("%s#getFile() for %s origin %s", this.getSimpleClassName(), this.origin.getClass().getSimpleName(), this.origin));
    }

    public InputStream getInputStream(OpenOption ... openOptionArray) {
        return Files.newInputStream(this.getPath(), openOptionArray);
    }

    public OutputStream getOutputStream(OpenOption ... openOptionArray) {
        return Files.newOutputStream(this.getPath(), openOptionArray);
    }

    public Path getPath() {
        throw new UnsupportedOperationException(String.format("%s#getPath() for %s origin %s", this.getSimpleClassName(), this.origin.getClass().getSimpleName(), this.origin));
    }

    public RandomAccessFile getRandomAccessFile(OpenOption ... openOptionArray) {
        return RandomAccessFileMode.valueOf(openOptionArray).create(this.getFile());
    }

    public Reader getReader(Charset charset) {
        return Files.newBufferedReader(this.getPath(), charset);
    }

    private String getSimpleClassName() {
        return this.getClass().getSimpleName();
    }

    public Writer getWriter(Charset charset, OpenOption ... openOptionArray) {
        return Files.newBufferedWriter(this.getPath(), charset, openOptionArray);
    }

    public long size() {
        return Files.size(this.getPath());
    }

    public String toString() {
        return this.getSimpleClassName() + "[" + this.origin.toString() + "]";
    }
}

