/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import org.apache.commons.io.build.AbstractOrigin;
import org.apache.commons.io.file.spi.FileSystemProviders;

public class AbstractOrigin$URIOrigin
extends AbstractOrigin {
    private static final String SCHEME_HTTPS = "https";
    private static final String SCHEME_HTTP = "http";

    public AbstractOrigin$URIOrigin(URI uRI) {
        super(uRI);
    }

    @Override
    public File getFile() {
        return this.getPath().toFile();
    }

    @Override
    public InputStream getInputStream(OpenOption ... openOptionArray) {
        URI uRI = (URI)this.get();
        String string = uRI.getScheme();
        FileSystemProvider fileSystemProvider = FileSystemProviders.installed().getFileSystemProvider(string);
        if (fileSystemProvider != null) {
            return Files.newInputStream(fileSystemProvider.getPath(uRI), openOptionArray);
        }
        if (SCHEME_HTTP.equalsIgnoreCase(string) || SCHEME_HTTPS.equalsIgnoreCase(string)) {
            return uRI.toURL().openStream();
        }
        return Files.newInputStream(this.getPath(), openOptionArray);
    }

    @Override
    public Path getPath() {
        return Paths.get((URI)this.get());
    }
}

