/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.build;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import org.apache.commons.io.RandomAccessFiles;
import org.apache.commons.io.build.AbstractOrigin;
import org.apache.commons.io.input.BufferedFileChannelInputStream;
import org.apache.commons.io.output.RandomAccessFileOutputStream;
import org.apache.commons.io.output.RandomAccessFileOutputStream$Builder;

public abstract class AbstractOrigin$AbstractRandomAccessFileOrigin
extends AbstractOrigin {
    public AbstractOrigin$AbstractRandomAccessFileOrigin(RandomAccessFile randomAccessFile) {
        super(randomAccessFile);
    }

    @Override
    public byte[] getByteArray() {
        long l2 = ((RandomAccessFile)this.origin).length();
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalStateException("Origin too large.");
        }
        return RandomAccessFiles.read((RandomAccessFile)this.origin, 0L, (int)l2);
    }

    @Override
    public byte[] getByteArray(long l2, int n2) {
        return RandomAccessFiles.read((RandomAccessFile)this.origin, l2, n2);
    }

    @Override
    public CharSequence getCharSequence(Charset charset) {
        return new String(this.getByteArray(), charset);
    }

    @Override
    public InputStream getInputStream(OpenOption ... openOptionArray) {
        return BufferedFileChannelInputStream.builder().setFileChannel(((RandomAccessFile)this.origin).getChannel()).get();
    }

    @Override
    public OutputStream getOutputStream(OpenOption ... openOptionArray) {
        return ((RandomAccessFileOutputStream$Builder)RandomAccessFileOutputStream.builder().setRandomAccessFile((RandomAccessFile)this.origin)).get();
    }

    @Override
    public RandomAccessFile getRandomAccessFile(OpenOption ... openOptionArray) {
        return (RandomAccessFile)this.get();
    }

    @Override
    public Reader getReader(Charset charset) {
        return new InputStreamReader(this.getInputStream(new OpenOption[0]), charset);
    }

    @Override
    public Writer getWriter(Charset charset, OpenOption ... openOptionArray) {
        return new OutputStreamWriter(this.getOutputStream(openOptionArray), charset);
    }

    @Override
    public long size() {
        return ((RandomAccessFile)this.origin).length();
    }
}

