/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public final class StreamIterator
implements AutoCloseable,
Iterator {
    private final Iterator iterator;
    private final Stream stream;
    private boolean closed;

    public static StreamIterator iterator(Stream stream) {
        return new StreamIterator(stream);
    }

    private StreamIterator(Stream stream) {
        this.stream = Objects.requireNonNull(stream, "stream");
        this.iterator = stream.iterator();
    }

    @Override
    public void close() {
        this.closed = true;
        this.stream.close();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean bl2 = this.iterator.hasNext();
        if (!bl2) {
            this.close();
        }
        return bl2;
    }

    public Object next() {
        Object e2 = this.iterator.next();
        if (e2 == null) {
            this.close();
        }
        return e2;
    }
}

