/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import org.apache.commons.io.IORandomAccessFile;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;

public enum RandomAccessFileMode {
    READ_ONLY("r", 1),
    READ_WRITE("rw", 2),
    READ_WRITE_SYNC_ALL("rws", 4),
    READ_WRITE_SYNC_CONTENT("rwd", 3);

    private static final String R = "r";
    private static final String RW = "rw";
    private static final String RWD = "rwd";
    private static final String RWS = "rws";
    private final int level;
    private final String mode;

    public static RandomAccessFileMode valueOf(OpenOption ... openOptionArray) {
        RandomAccessFileMode randomAccessFileMode = READ_ONLY;
        block5: for (OpenOption openOption : openOptionArray) {
            if (!(openOption instanceof StandardOpenOption)) continue;
            switch ((StandardOpenOption)openOption) {
                case WRITE: {
                    if (randomAccessFileMode.implies(READ_WRITE)) continue block5;
                    randomAccessFileMode = READ_WRITE;
                    continue block5;
                }
                case DSYNC: {
                    if (randomAccessFileMode.implies(READ_WRITE_SYNC_CONTENT)) continue block5;
                    randomAccessFileMode = READ_WRITE_SYNC_CONTENT;
                    continue block5;
                }
                case SYNC: {
                    if (randomAccessFileMode.implies(READ_WRITE_SYNC_ALL)) continue block5;
                    randomAccessFileMode = READ_WRITE_SYNC_ALL;
                    continue block5;
                }
                default: {
                    continue block5;
                }
            }
        }
        return randomAccessFileMode;
    }

    public static RandomAccessFileMode valueOfMode(String string) {
        switch (string) {
            case "r": {
                return READ_ONLY;
            }
            case "rw": {
                return READ_WRITE;
            }
            case "rwd": {
                return READ_WRITE_SYNC_CONTENT;
            }
            case "rws": {
                return READ_WRITE_SYNC_ALL;
            }
        }
        throw new IllegalArgumentException(string);
    }

    /*
     * WARNING - void declaration
     */
    private RandomAccessFileMode() {
        void var4_1;
        void var3_2;
        this.mode = var3_2;
        this.level = var4_1;
    }

    public void accept(Path path, IOConsumer iOConsumer) {
        try (RandomAccessFile randomAccessFile = this.create(path);){
            iOConsumer.accept(randomAccessFile);
        }
    }

    public Object apply(Path path, IOFunction iOFunction) {
        try (RandomAccessFile randomAccessFile = this.create(path);){
            Object object = iOFunction.apply(randomAccessFile);
            return object;
        }
    }

    public RandomAccessFile create(File file) {
        return new IORandomAccessFile(file, this.mode);
    }

    public RandomAccessFile create(Path path) {
        return this.create(Objects.requireNonNull(path.toFile(), "file"));
    }

    public RandomAccessFile create(String string) {
        return new IORandomAccessFile(string, this.mode);
    }

    private int getLevel() {
        return this.level;
    }

    public String getMode() {
        return this.mode;
    }

    public boolean implies(RandomAccessFileMode randomAccessFileMode) {
        return this.getLevel() >= randomAccessFileMode.getLevel();
    }

    public IORandomAccessFile io(String string) {
        return new IORandomAccessFile(string, this.mode);
    }
}

