/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.CloseableURLConnection;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.StandardLineSeparator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOSupplier;
import org.apache.commons.io.function.IOTriFunction;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.commons.io.input.QueueInputStream;
import org.apache.commons.io.output.AppendableWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.NullWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;

public class IOUtils {
    public static final int CR = 13;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int EOF = -1;
    public static final int LF = 10;
    @Deprecated
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String LINE_SEPARATOR_UNIX = StandardLineSeparator.LF.getString();
    public static final String LINE_SEPARATOR_WINDOWS = StandardLineSeparator.CRLF.getString();
    private static final ThreadLocal SCRATCH_BYTE_BUFFER_RW = ThreadLocal.withInitial(IOUtils::byteArray);
    private static final byte[] SCRATCH_BYTE_BUFFER_WO = IOUtils.byteArray();
    private static final ThreadLocal SCRATCH_CHAR_BUFFER_RW = ThreadLocal.withInitial(IOUtils::charArray);
    private static final char[] SCRATCH_CHAR_BUFFER_WO = IOUtils.charArray();

    public static BufferedInputStream buffer(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public static BufferedInputStream buffer(InputStream inputStream, int n2) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, n2);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
    }

    public static BufferedOutputStream buffer(OutputStream outputStream, int n2) {
        Objects.requireNonNull(outputStream, "outputStream");
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, n2);
    }

    public static BufferedReader buffer(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader buffer(Reader reader, int n2) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
    }

    public static BufferedWriter buffer(Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static BufferedWriter buffer(Writer writer, int n2) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n2);
    }

    public static byte[] byteArray() {
        return IOUtils.byteArray(8192);
    }

    public static byte[] byteArray(int n2) {
        return new byte[n2];
    }

    private static char[] charArray() {
        return IOUtils.charArray(8192);
    }

    private static char[] charArray(int n2) {
        return new char[n2];
    }

    static void clear() {
        SCRATCH_BYTE_BUFFER_RW.remove();
        SCRATCH_CHAR_BUFFER_RW.remove();
        Arrays.fill(SCRATCH_BYTE_BUFFER_WO, (byte)0);
        Arrays.fill(SCRATCH_CHAR_BUFFER_WO, '\u0000');
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(Closeable ... closeableArray) {
        IOConsumer.forAll(IOUtils::close, closeableArray);
    }

    public static void close(Closeable closeable, IOConsumer iOConsumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (iOConsumer == null) break block3;
                    iOConsumer.accept(iOException);
                }
            }
        }
    }

    public static void close(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    private static void closeQ(Closeable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Closeable ... closeableArray) {
        if (closeableArray != null) {
            IOUtils.closeQuietly(Arrays.stream(closeableArray));
        }
    }

    public static void closeQuietly(Closeable closeable, Consumer consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    if (consumer == null) break block3;
                    consumer.accept(iOException);
                }
            }
        }
    }

    public static void closeQuietly(InputStream inputStream) {
        IOUtils.closeQ(inputStream);
    }

    public static void closeQuietly(Iterable iterable) {
        if (iterable != null) {
            iterable.forEach(IOUtils::closeQuietly);
        }
    }

    public static void closeQuietly(OutputStream outputStream) {
        IOUtils.closeQ(outputStream);
    }

    public static void closeQuietly(Reader reader) {
        IOUtils.closeQ(reader);
    }

    public static void closeQuietly(Selector selector) {
        IOUtils.closeQ(selector);
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        IOUtils.closeQ(serverSocket);
    }

    public static void closeQuietly(Socket socket) {
        IOUtils.closeQ(socket);
    }

    public static void closeQuietly(Stream stream) {
        if (stream != null) {
            stream.forEach(IOUtils::closeQuietly);
        }
    }

    public static void closeQuietly(Writer writer) {
        IOUtils.closeQ(writer);
    }

    public static long consume(InputStream inputStream) {
        return IOUtils.copyLarge(inputStream, NullOutputStream.INSTANCE);
    }

    public static long consume(Reader reader) {
        return IOUtils.copyLarge(reader, NullWriter.INSTANCE);
    }

    public static boolean contentEquals(InputStream inputStream, InputStream inputStream2) {
        if (inputStream == inputStream2) {
            return true;
        }
        if (inputStream == null || inputStream2 == null) {
            return false;
        }
        byte[] byArray = IOUtils.getScratchByteArray();
        byte[] byArray2 = IOUtils.byteArray();
        block0: while (true) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if (n4 >= 8192) continue block0;
                if (n2 == n4) {
                    int n5;
                    while ((n5 = inputStream.read(byArray, n2, 8192 - n2)) == 0) {
                    }
                    if (n5 == -1) {
                        return n3 == n4 && inputStream2.read() == -1;
                    }
                    n2 += n5;
                }
                if (n3 == n4) {
                    int n6;
                    while ((n6 = inputStream2.read(byArray2, n3, 8192 - n3)) == 0) {
                    }
                    if (n6 == -1) {
                        return n2 == n4 && inputStream.read() == -1;
                    }
                    n3 += n6;
                }
                if (byArray[n4] != byArray2[n4]) {
                    return false;
                }
                ++n4;
            }
            break;
        }
    }

    private static boolean contentEquals(Iterator iterator, Iterator iterator2) {
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return false;
            }
            if (Objects.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static boolean contentEquals(Reader reader, Reader reader2) {
        if (reader == reader2) {
            return true;
        }
        if (reader == null || reader2 == null) {
            return false;
        }
        char[] cArray = IOUtils.getScratchCharArray();
        char[] cArray2 = IOUtils.charArray();
        block0: while (true) {
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if (n4 >= 8192) continue block0;
                if (n2 == n4) {
                    int n5;
                    while ((n5 = reader.read(cArray, n2, 8192 - n2)) == 0) {
                    }
                    if (n5 == -1) {
                        return n3 == n4 && reader2.read() == -1;
                    }
                    n2 += n5;
                }
                if (n3 == n4) {
                    int n6;
                    while ((n6 = reader2.read(cArray2, n3, 8192 - n3)) == 0) {
                    }
                    if (n6 == -1) {
                        return n2 == n4 && reader.read() == -1;
                    }
                    n3 += n6;
                }
                if (cArray[n4] != cArray2[n4]) {
                    return false;
                }
                ++n4;
            }
            break;
        }
    }

    private static boolean contentEquals(Stream stream, Stream stream2) {
        if (stream == stream2) {
            return true;
        }
        if (stream == null || stream2 == null) {
            return false;
        }
        return IOUtils.contentEquals(stream.iterator(), stream2.iterator());
    }

    private static boolean contentEqualsIgnoreEOL(BufferedReader bufferedReader, BufferedReader bufferedReader2) {
        if (bufferedReader == bufferedReader2) {
            return true;
        }
        if (bufferedReader == null || bufferedReader2 == null) {
            return false;
        }
        return IOUtils.contentEquals(bufferedReader.lines(), bufferedReader2.lines());
    }

    public static boolean contentEqualsIgnoreEOL(Reader reader, Reader reader2) {
        if (reader == reader2) {
            return true;
        }
        if (reader == null || reader2 == null) {
            return false;
        }
        return IOUtils.contentEqualsIgnoreEOL(IOUtils.toBufferedReader(reader), IOUtils.toBufferedReader(reader2));
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) {
        long l2 = IOUtils.copyLarge(inputStream, outputStream);
        return l2 > Integer.MAX_VALUE ? -1 : (int)l2;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, int n2) {
        return IOUtils.copyLarge(inputStream, outputStream, IOUtils.byteArray(n2));
    }

    @Deprecated
    public static void copy(InputStream inputStream, Writer writer) {
        IOUtils.copy(inputStream, writer, Charset.defaultCharset());
    }

    public static void copy(InputStream inputStream, Writer writer, Charset charset) {
        IOUtils.copy((Reader)new InputStreamReader(inputStream, Charsets.toCharset(charset)), writer);
    }

    public static void copy(InputStream inputStream, Writer writer, String string) {
        IOUtils.copy(inputStream, writer, Charsets.toCharset(string));
    }

    public static QueueInputStream copy(java.io.ByteArrayOutputStream byteArrayOutputStream) {
        Objects.requireNonNull(byteArrayOutputStream, "outputStream");
        QueueInputStream queueInputStream = new QueueInputStream();
        byteArrayOutputStream.writeTo(queueInputStream.newQueueOutputStream());
        return queueInputStream;
    }

    public static long copy(Reader reader, Appendable appendable) {
        return IOUtils.copy(reader, appendable, CharBuffer.allocate(8192));
    }

    public static long copy(Reader reader, Appendable appendable, CharBuffer charBuffer) {
        int n2;
        long l2 = 0L;
        while (-1 != (n2 = reader.read(charBuffer))) {
            charBuffer.flip();
            appendable.append(charBuffer, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    @Deprecated
    public static void copy(Reader reader, OutputStream outputStream) {
        IOUtils.copy(reader, outputStream, Charset.defaultCharset());
    }

    public static void copy(Reader reader, OutputStream outputStream, Charset charset) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, Charsets.toCharset(charset));
        IOUtils.copy(reader, (Writer)outputStreamWriter);
        outputStreamWriter.flush();
    }

    public static void copy(Reader reader, OutputStream outputStream, String string) {
        IOUtils.copy(reader, outputStream, Charsets.toCharset(string));
    }

    public static int copy(Reader reader, Writer writer) {
        long l2 = IOUtils.copyLarge(reader, writer);
        if (l2 > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l2;
    }

    public static long copy(URL uRL, File file) {
        try (OutputStream outputStream = Files.newOutputStream(Objects.requireNonNull(file, "file").toPath(), new OpenOption[0]);){
            long l2 = IOUtils.copy(uRL, outputStream);
            return l2;
        }
    }

    public static long copy(URL uRL, OutputStream outputStream) {
        try (InputStream inputStream = Objects.requireNonNull(uRL, "url").openStream();){
            long l2 = IOUtils.copyLarge(inputStream, outputStream);
            return l2;
        }
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream) {
        return IOUtils.copy(inputStream, outputStream, 8192);
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, byte[] byArray) {
        int n2;
        Objects.requireNonNull(inputStream, "inputStream");
        Objects.requireNonNull(outputStream, "outputStream");
        long l2 = 0L;
        while (-1 != (n2 = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3) {
        return IOUtils.copyLarge(inputStream, outputStream, l2, l3, IOUtils.getScratchByteArray());
    }

    public static long copyLarge(InputStream inputStream, OutputStream outputStream, long l2, long l3, byte[] byArray) {
        int n2;
        int n3;
        if (l2 > 0L) {
            IOUtils.skipFully(inputStream, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n4 = n3 = byArray.length;
        if (l3 > 0L && l3 < (long)n3) {
            n4 = (int)l3;
        }
        long l4 = 0L;
        while (n4 > 0 && -1 != (n2 = inputStream.read(byArray, 0, n4))) {
            outputStream.write(byArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n4 = (int)Math.min(l3 - l4, (long)n3);
        }
        return l4;
    }

    public static long copyLarge(Reader reader, Writer writer) {
        return IOUtils.copyLarge(reader, writer, IOUtils.getScratchCharArray());
    }

    public static long copyLarge(Reader reader, Writer writer, char[] cArray) {
        int n2;
        long l2 = 0L;
        while (-1 != (n2 = reader.read(cArray))) {
            writer.write(cArray, 0, n2);
            l2 += (long)n2;
        }
        return l2;
    }

    public static long copyLarge(Reader reader, Writer writer, long l2, long l3) {
        return IOUtils.copyLarge(reader, writer, l2, l3, IOUtils.getScratchCharArray());
    }

    public static long copyLarge(Reader reader, Writer writer, long l2, long l3, char[] cArray) {
        int n2;
        if (l2 > 0L) {
            IOUtils.skipFully(reader, l2);
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n3 = cArray.length;
        if (l3 > 0L && l3 < (long)cArray.length) {
            n3 = (int)l3;
        }
        long l4 = 0L;
        while (n3 > 0 && -1 != (n2 = reader.read(cArray, 0, n3))) {
            writer.write(cArray, 0, n2);
            l4 += (long)n2;
            if (l3 <= 0L) continue;
            n3 = (int)Math.min(l3 - l4, (long)cArray.length);
        }
        return l4;
    }

    private static byte[] fill0(byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
        return byArray;
    }

    private static char[] fill0(char[] cArray) {
        Arrays.fill(cArray, '\u0000');
        return cArray;
    }

    static byte[] getScratchByteArray() {
        return IOUtils.fill0((byte[])SCRATCH_BYTE_BUFFER_RW.get());
    }

    static byte[] getScratchByteArrayWriteOnly() {
        return IOUtils.fill0(SCRATCH_BYTE_BUFFER_WO);
    }

    static char[] getScratchCharArray() {
        return IOUtils.fill0((char[])SCRATCH_CHAR_BUFFER_RW.get());
    }

    static char[] getScratchCharArrayWriteOnly() {
        return IOUtils.fill0(SCRATCH_CHAR_BUFFER_WO);
    }

    public static int length(byte[] byArray) {
        return byArray == null ? 0 : byArray.length;
    }

    public static int length(char[] cArray) {
        return cArray == null ? 0 : cArray.length;
    }

    public static int length(CharSequence charSequence) {
        return charSequence == null ? 0 : charSequence.length();
    }

    public static int length(Object[] objectArray) {
        return objectArray == null ? 0 : objectArray.length;
    }

    public static LineIterator lineIterator(InputStream inputStream, Charset charset) {
        return new LineIterator(new InputStreamReader(inputStream, Charsets.toCharset(charset)));
    }

    public static LineIterator lineIterator(InputStream inputStream, String string) {
        return IOUtils.lineIterator(inputStream, Charsets.toCharset(string));
    }

    public static LineIterator lineIterator(Reader reader) {
        return new LineIterator(reader);
    }

    public static int read(InputStream inputStream, byte[] byArray) {
        return IOUtils.read(inputStream, byArray, 0, byArray.length);
    }

    public static int read(InputStream inputStream, byte[] byArray, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        return IOUtils.read(inputStream::read, byArray, n2, n3);
    }

    static int read(IOTriFunction iOTriFunction, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n5 = n3; n5 > 0 && -1 != (n6 = ((Integer)iOTriFunction.apply(byArray, n2 + (n4 = n3 - n5), n5)).intValue()); n5 -= n6) {
        }
        return n3 - n5;
    }

    public static int read(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) {
        int n2;
        int n3 = byteBuffer.remaining();
        while (byteBuffer.remaining() > 0 && -1 != (n2 = readableByteChannel.read(byteBuffer))) {
        }
        return n3 - byteBuffer.remaining();
    }

    public static int read(Reader reader, char[] cArray) {
        return IOUtils.read(reader, cArray, 0, cArray.length);
    }

    public static int read(Reader reader, char[] cArray, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n3 < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + n3);
        }
        for (n5 = n3; n5 > 0 && -1 != (n6 = reader.read(cArray, n2 + (n4 = n3 - n5), n5)); n5 -= n6) {
        }
        return n3 - n5;
    }

    public static void readFully(InputStream inputStream, byte[] byArray) {
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n2, int n3) {
        int n4 = IOUtils.read(inputStream, byArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    public static byte[] readFully(InputStream inputStream, int n2) {
        byte[] byArray = IOUtils.byteArray(n2);
        IOUtils.readFully(inputStream, byArray, 0, byArray.length);
        return byArray;
    }

    public static void readFully(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) {
        int n2 = byteBuffer.remaining();
        int n3 = IOUtils.read(readableByteChannel, byteBuffer);
        if (n3 != n2) {
            throw new EOFException("Length to read: " + n2 + " actual: " + n3);
        }
    }

    public static void readFully(Reader reader, char[] cArray) {
        IOUtils.readFully(reader, cArray, 0, cArray.length);
    }

    public static void readFully(Reader reader, char[] cArray, int n2, int n3) {
        int n4 = IOUtils.read(reader, cArray, n2, n3);
        if (n4 != n3) {
            throw new EOFException("Length to read: " + n3 + " actual: " + n4);
        }
    }

    public static List readLines(CharSequence charSequence) {
        try (CharSequenceReader charSequenceReader = new CharSequenceReader(charSequence);){
            List list = IOUtils.readLines(charSequenceReader);
            return list;
        }
    }

    @Deprecated
    public static List readLines(InputStream inputStream) {
        return IOUtils.readLines(inputStream, Charset.defaultCharset());
    }

    public static List readLines(InputStream inputStream, Charset charset) {
        return IOUtils.readLines(new InputStreamReader(inputStream, Charsets.toCharset(charset)));
    }

    public static List readLines(InputStream inputStream, String string) {
        return IOUtils.readLines(inputStream, Charsets.toCharset(string));
    }

    public static List readLines(Reader reader) {
        return IOUtils.toBufferedReader(reader).lines().collect(Collectors.toList());
    }

    public static byte[] resourceToByteArray(String string) {
        return IOUtils.resourceToByteArray(string, null);
    }

    public static byte[] resourceToByteArray(String string, ClassLoader classLoader) {
        return IOUtils.toByteArray(IOUtils.resourceToURL(string, classLoader));
    }

    public static String resourceToString(String string, Charset charset) {
        return IOUtils.resourceToString(string, charset, null);
    }

    public static String resourceToString(String string, Charset charset, ClassLoader classLoader) {
        return IOUtils.toString(IOUtils.resourceToURL(string, classLoader), charset);
    }

    public static URL resourceToURL(String string) {
        return IOUtils.resourceToURL(string, null);
    }

    public static URL resourceToURL(String string, ClassLoader classLoader) {
        URL uRL;
        URL uRL2 = uRL = classLoader == null ? IOUtils.class.getResource(string) : classLoader.getResource(string);
        if (uRL == null) {
            throw new IOException("Resource not found: " + string);
        }
        return uRL;
    }

    public static long skip(InputStream inputStream, long l2) {
        return IOUtils.skip(inputStream, l2, IOUtils::getScratchByteArrayWriteOnly);
    }

    public static long skip(InputStream inputStream, long l2, Supplier supplier) {
        byte[] byArray;
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)inputStream.read(byArray = (byte[])supplier.get(), 0, (int)Math.min(l3, (long)byArray.length))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static long skip(ReadableByteChannel readableByteChannel, long l2) {
        long l3;
        int n2;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)Math.min(l2, 8192L));
        for (l3 = l2; l3 > 0L; l3 -= (long)n2) {
            byteBuffer.position(0);
            byteBuffer.limit((int)Math.min(l3, 8192L));
            n2 = readableByteChannel.read(byteBuffer);
            if (n2 == -1) break;
        }
        return l2 - l3;
    }

    public static long skip(Reader reader, long l2) {
        char[] cArray;
        long l3;
        long l4;
        if (l2 < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + l2);
        }
        for (l3 = l2; l3 > 0L && (l4 = (long)reader.read(cArray = IOUtils.getScratchCharArrayWriteOnly(), 0, (int)Math.min(l3, (long)cArray.length))) >= 0L; l3 -= l4) {
        }
        return l2 - l3;
    }

    public static void skipFully(InputStream inputStream, long l2) {
        long l3 = IOUtils.skip(inputStream, l2, IOUtils::getScratchByteArrayWriteOnly);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(InputStream inputStream, long l2, Supplier supplier) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l2);
        }
        long l3 = IOUtils.skip(inputStream, l2, supplier);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(ReadableByteChannel readableByteChannel, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + l2);
        }
        long l3 = IOUtils.skip(readableByteChannel, l2);
        if (l3 != l2) {
            throw new EOFException("Bytes to skip: " + l2 + " actual: " + l3);
        }
    }

    public static void skipFully(Reader reader, long l2) {
        long l3 = IOUtils.skip(reader, l2);
        if (l3 != l2) {
            throw new EOFException("Chars to skip: " + l2 + " actual: " + l3);
        }
    }

    public static InputStream toBufferedInputStream(InputStream inputStream) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream);
    }

    public static InputStream toBufferedInputStream(InputStream inputStream, int n2) {
        return ByteArrayOutputStream.toBufferedInputStream(inputStream, n2);
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader toBufferedReader(Reader reader, int n2) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2);
    }

    public static byte[] toByteArray(InputStream inputStream) {
        try (UnsynchronizedByteArrayOutputStream unsynchronizedByteArrayOutputStream = UnsynchronizedByteArrayOutputStream.builder().get();){
            ThresholdingOutputStream thresholdingOutputStream2 = new ThresholdingOutputStream(Integer.MAX_VALUE, thresholdingOutputStream -> {
                throw new IllegalArgumentException(String.format("Cannot read more than %,d into a byte array", Integer.MAX_VALUE));
            }, thresholdingOutputStream -> unsynchronizedByteArrayOutputStream);
            try {
                IOUtils.copy(inputStream, (OutputStream)thresholdingOutputStream2);
                byte[] byArray = unsynchronizedByteArrayOutputStream.toByteArray();
                thresholdingOutputStream2.close();
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    thresholdingOutputStream2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static byte[] toByteArray(InputStream inputStream, int n2) {
        if (n2 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        return IOUtils.toByteArray(Objects.requireNonNull(inputStream, "input")::read, n2);
    }

    public static byte[] toByteArray(InputStream inputStream, long l2) {
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + l2);
        }
        return IOUtils.toByteArray(inputStream, (int)l2);
    }

    static byte[] toByteArray(IOTriFunction iOTriFunction, int n2) {
        int n3;
        int n4;
        if (n2 < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + n2);
        }
        if (n2 == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = IOUtils.byteArray(n2);
        for (n3 = 0; n3 < n2 && (n4 = ((Integer)iOTriFunction.apply(byArray, n3, n2 - n3)).intValue()) != -1; n3 += n4) {
        }
        if (n3 != n2) {
            throw new IOException("Unexpected read size, current: " + n3 + ", expected: " + n2);
        }
        return byArray;
    }

    @Deprecated
    public static byte[] toByteArray(Reader reader) {
        return IOUtils.toByteArray(reader, Charset.defaultCharset());
    }

    public static byte[] toByteArray(Reader reader, Charset charset) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            IOUtils.copy(reader, (OutputStream)byteArrayOutputStream, charset);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] toByteArray(Reader reader, String string) {
        return IOUtils.toByteArray(reader, Charsets.toCharset(string));
    }

    @Deprecated
    public static byte[] toByteArray(String string) {
        return string.getBytes(Charset.defaultCharset());
    }

    public static byte[] toByteArray(URI uRI) {
        return IOUtils.toByteArray(uRI.toURL());
    }

    public static byte[] toByteArray(URL uRL) {
        try (CloseableURLConnection closeableURLConnection = CloseableURLConnection.open(uRL);){
            byte[] byArray = IOUtils.toByteArray(closeableURLConnection);
            return byArray;
        }
    }

    public static byte[] toByteArray(URLConnection uRLConnection) {
        try (InputStream inputStream = uRLConnection.getInputStream();){
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return byArray;
        }
    }

    @Deprecated
    public static char[] toCharArray(InputStream inputStream) {
        return IOUtils.toCharArray(inputStream, Charset.defaultCharset());
    }

    public static char[] toCharArray(InputStream inputStream, Charset charset) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(inputStream, (Writer)charArrayWriter, charset);
        return charArrayWriter.toCharArray();
    }

    public static char[] toCharArray(InputStream inputStream, String string) {
        return IOUtils.toCharArray(inputStream, Charsets.toCharset(string));
    }

    public static char[] toCharArray(Reader reader) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        IOUtils.copy(reader, (Writer)charArrayWriter);
        return charArrayWriter.toCharArray();
    }

    @Deprecated
    public static InputStream toInputStream(CharSequence charSequence) {
        return IOUtils.toInputStream(charSequence, Charset.defaultCharset());
    }

    public static InputStream toInputStream(CharSequence charSequence, Charset charset) {
        return IOUtils.toInputStream(charSequence.toString(), charset);
    }

    public static InputStream toInputStream(CharSequence charSequence, String string) {
        return IOUtils.toInputStream(charSequence, Charsets.toCharset(string));
    }

    @Deprecated
    public static InputStream toInputStream(String string) {
        return IOUtils.toInputStream(string, Charset.defaultCharset());
    }

    public static InputStream toInputStream(String string, Charset charset) {
        return new ByteArrayInputStream(string.getBytes(Charsets.toCharset(charset)));
    }

    public static InputStream toInputStream(String string, String string2) {
        return new ByteArrayInputStream(string.getBytes(Charsets.toCharset(string2)));
    }

    @Deprecated
    public static String toString(byte[] byArray) {
        return new String(byArray, Charset.defaultCharset());
    }

    public static String toString(byte[] byArray, String string) {
        return new String(byArray, Charsets.toCharset(string));
    }

    @Deprecated
    public static String toString(InputStream inputStream) {
        return IOUtils.toString(inputStream, Charset.defaultCharset());
    }

    public static String toString(InputStream inputStream, Charset charset) {
        try (StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();){
            IOUtils.copy(inputStream, (Writer)stringBuilderWriter, charset);
            String string = stringBuilderWriter.toString();
            return string;
        }
    }

    public static String toString(InputStream inputStream, String string) {
        return IOUtils.toString(inputStream, Charsets.toCharset(string));
    }

    public static String toString(IOSupplier iOSupplier, Charset charset) {
        return IOUtils.toString(iOSupplier, charset, () -> {
            throw new NullPointerException("input");
        });
    }

    public static String toString(IOSupplier iOSupplier, Charset charset, IOSupplier iOSupplier2) {
        if (iOSupplier == null) {
            return (String)iOSupplier2.get();
        }
        try (InputStream inputStream = (InputStream)iOSupplier.get();){
            String string = inputStream != null ? IOUtils.toString(inputStream, charset) : (String)iOSupplier2.get();
            return string;
        }
    }

    public static String toString(Reader reader) {
        try (StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();){
            IOUtils.copy(reader, (Writer)stringBuilderWriter);
            String string = stringBuilderWriter.toString();
            return string;
        }
    }

    @Deprecated
    public static String toString(URI uRI) {
        return IOUtils.toString(uRI, Charset.defaultCharset());
    }

    public static String toString(URI uRI, Charset charset) {
        return IOUtils.toString(uRI.toURL(), Charsets.toCharset(charset));
    }

    public static String toString(URI uRI, String string) {
        return IOUtils.toString(uRI, Charsets.toCharset(string));
    }

    @Deprecated
    public static String toString(URL uRL) {
        return IOUtils.toString(uRL, Charset.defaultCharset());
    }

    public static String toString(URL uRL, Charset charset) {
        return IOUtils.toString(uRL::openStream, charset);
    }

    public static String toString(URL uRL, String string) {
        return IOUtils.toString(uRL, Charsets.toCharset(string));
    }

    public static void write(byte[] byArray, OutputStream outputStream) {
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    @Deprecated
    public static void write(byte[] byArray, Writer writer) {
        IOUtils.write(byArray, writer, Charset.defaultCharset());
    }

    public static void write(byte[] byArray, Writer writer, Charset charset) {
        if (byArray != null) {
            writer.write(new String(byArray, Charsets.toCharset(charset)));
        }
    }

    public static void write(byte[] byArray, Writer writer, String string) {
        IOUtils.write(byArray, writer, Charsets.toCharset(string));
    }

    @Deprecated
    public static void write(char[] cArray, OutputStream outputStream) {
        IOUtils.write(cArray, outputStream, Charset.defaultCharset());
    }

    public static void write(char[] cArray, OutputStream outputStream, Charset charset) {
        if (cArray != null) {
            IOUtils.write(new String(cArray), outputStream, charset);
        }
    }

    public static void write(char[] cArray, OutputStream outputStream, String string) {
        IOUtils.write(cArray, outputStream, Charsets.toCharset(string));
    }

    public static void write(char[] cArray, Writer writer) {
        if (cArray != null) {
            writer.write(cArray);
        }
    }

    @Deprecated
    public static void write(CharSequence charSequence, OutputStream outputStream) {
        IOUtils.write(charSequence, outputStream, Charset.defaultCharset());
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, Charset charset) {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), outputStream, charset);
        }
    }

    public static void write(CharSequence charSequence, OutputStream outputStream, String string) {
        IOUtils.write(charSequence, outputStream, Charsets.toCharset(string));
    }

    public static void write(CharSequence charSequence, Writer writer) {
        if (charSequence != null) {
            IOUtils.write(charSequence.toString(), writer);
        }
    }

    @Deprecated
    public static void write(String string, OutputStream outputStream) {
        IOUtils.write(string, outputStream, Charset.defaultCharset());
    }

    public static void write(String string, OutputStream outputStream, Charset charset) {
        if (string != null) {
            Channels.newChannel(outputStream).write(Charsets.toCharset(charset).encode(string));
        }
    }

    public static void write(String string, OutputStream outputStream, String string2) {
        IOUtils.write(string, outputStream, Charsets.toCharset(string2));
    }

    public static void write(String string, Writer writer) {
        if (string != null) {
            writer.write(string);
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream) {
        IOUtils.write(stringBuffer, outputStream, (String)null);
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, OutputStream outputStream, String string) {
        if (stringBuffer != null) {
            IOUtils.write(stringBuffer.toString(), outputStream, Charsets.toCharset(string));
        }
    }

    @Deprecated
    public static void write(StringBuffer stringBuffer, Writer writer) {
        if (stringBuffer != null) {
            writer.write(stringBuffer.toString());
        }
    }

    public static void writeChunked(byte[] byArray, OutputStream outputStream) {
        if (byArray != null) {
            int n2 = byArray.length;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = Math.min(n2, 8192);
                outputStream.write(byArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            }
        }
    }

    public static void writeChunked(char[] cArray, Writer writer) {
        if (cArray != null) {
            int n2 = cArray.length;
            int n3 = 0;
            while (n2 > 0) {
                int n4 = Math.min(n2, 8192);
                writer.write(cArray, n3, n4);
                n2 -= n4;
                n3 += n4;
            }
        }
    }

    @Deprecated
    public static void writeLines(Collection collection, String string, OutputStream outputStream) {
        IOUtils.writeLines(collection, string, outputStream, Charset.defaultCharset());
    }

    public static void writeLines(Collection collection, String string, OutputStream outputStream, Charset charset) {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = System.lineSeparator();
        }
        if (StandardCharsets.UTF_16.equals(charset)) {
            charset = StandardCharsets.UTF_16BE;
        }
        byte[] byArray = string.getBytes(charset);
        for (Object e2 : collection) {
            if (e2 != null) {
                IOUtils.write(e2.toString(), outputStream, charset);
            }
            outputStream.write(byArray);
        }
    }

    public static void writeLines(Collection collection, String string, OutputStream outputStream, String string2) {
        IOUtils.writeLines(collection, string, outputStream, Charsets.toCharset(string2));
    }

    public static void writeLines(Collection collection, String string, Writer writer) {
        if (collection == null) {
            return;
        }
        if (string == null) {
            string = System.lineSeparator();
        }
        for (Object e2 : collection) {
            if (e2 != null) {
                writer.write(e2.toString());
            }
            writer.write(string);
        }
    }

    public static Writer writer(Appendable appendable) {
        Objects.requireNonNull(appendable, "appendable");
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        if (appendable instanceof StringBuilder) {
            return new StringBuilderWriter((StringBuilder)appendable);
        }
        return new AppendableWriter(appendable);
    }

    @Deprecated
    public IOUtils() {
    }
}

