/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class IOExceptionList
extends IOException
implements Iterable {
    private static final long serialVersionUID = 1L;
    private final List causeList;

    public static void checkEmpty(List list, Object object) {
        if (!IOExceptionList.isEmpty(list)) {
            throw new IOExceptionList(Objects.toString(object, null), list);
        }
    }

    private static boolean isEmpty(List list) {
        return IOExceptionList.size(list) == 0;
    }

    private static int size(List list) {
        return list != null ? list.size() : 0;
    }

    private static String toMessage(List list) {
        return String.format("%,d exception(s): %s", IOExceptionList.size(list), list);
    }

    public IOExceptionList(List list) {
        this(IOExceptionList.toMessage(list), list);
    }

    public IOExceptionList(String string, List list) {
        super(string != null ? string : IOExceptionList.toMessage(list), IOExceptionList.isEmpty(list) ? null : (Throwable)list.get(0));
        this.causeList = list == null ? Collections.emptyList() : list;
    }

    public Throwable getCause(int n2) {
        return (Throwable)this.causeList.get(n2);
    }

    public Throwable getCause(int n2, Class clazz) {
        return (Throwable)clazz.cast(this.getCause(n2));
    }

    public List getCauseList() {
        return new ArrayList(this.causeList);
    }

    public List getCauseList(Class clazz) {
        return new ArrayList(this.causeList);
    }

    public Iterator iterator() {
        return this.getCauseList().iterator();
    }
}

