/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.io.FileSystem;

public enum IOCase {
    SENSITIVE("Sensitive", true),
    INSENSITIVE("Insensitive", false),
    SYSTEM("System", FileSystem.getCurrent().isCaseSensitive());

    private static final long serialVersionUID = -6343169151696340687L;
    private final String name;
    private final transient boolean sensitive;

    public static IOCase forName(String string) {
        return Stream.of(IOCase.values()).filter(iOCase -> iOCase.getName().equals(string)).findFirst().orElseThrow(() -> new IllegalArgumentException("Illegal IOCase name: " + string));
    }

    public static boolean isCaseSensitive(IOCase iOCase) {
        return iOCase != null && iOCase.isCaseSensitive();
    }

    public static IOCase value(IOCase iOCase, IOCase iOCase2) {
        return iOCase != null ? iOCase : iOCase2;
    }

    /*
     * WARNING - void declaration
     */
    private IOCase() {
        void var4_1;
        void var3_2;
        this.name = var3_2;
        this.sensitive = var4_1;
    }

    public int checkCompareTo(String string, String string2) {
        Objects.requireNonNull(string, "str1");
        Objects.requireNonNull(string2, "str2");
        return this.sensitive ? string.compareTo(string2) : string.compareToIgnoreCase(string2);
    }

    public boolean checkEndsWith(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n2 = string2.length();
        return string.regionMatches(!this.sensitive, string.length() - n2, string2, 0, n2);
    }

    public boolean checkEquals(String string, String string2) {
        return string == string2 || string != null && (this.sensitive ? string.equals(string2) : string.equalsIgnoreCase(string2));
    }

    public int checkIndexOf(String string, int n2, String string2) {
        int n3;
        if (string != null && string2 != null && (n3 = string.length() - string2.length()) >= n2) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                if (!this.checkRegionMatches(string, i2, string2)) continue;
                return i2;
            }
        }
        return -1;
    }

    public boolean checkRegionMatches(String string, int n2, String string2) {
        return string != null && string2 != null && string.regionMatches(!this.sensitive, n2, string2, 0, string2.length());
    }

    public boolean checkStartsWith(String string, String string2) {
        return string != null && string2 != null && string.regionMatches(!this.sensitive, 0, string2, 0, string2.length());
    }

    public String getName() {
        return this.name;
    }

    public boolean isCaseSensitive() {
        return this.sensitive;
    }

    private Object readResolve() {
        return IOCase.forName(this.name);
    }

    public String toString() {
        return this.name;
    }
}

