/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.io.FileSystem;
import org.apache.commons.io.IOCase;

public class FilenameUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String EMPTY_STRING = "";
    private static final int NOT_FOUND = -1;
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final char UNIX_NAME_SEPARATOR = '/';
    private static final char WINDOWS_NAME_SEPARATOR = '\\';
    private static final char SYSTEM_NAME_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FilenameUtils.flipSeparator(SYSTEM_NAME_SEPARATOR);
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})$");
    private static final int IPV4_MAX_OCTET_VALUE = 255;
    private static final int IPV6_MAX_HEX_GROUPS = 8;
    private static final int IPV6_MAX_HEX_DIGITS_PER_GROUP = 4;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private static final int BASE_16 = 16;
    private static final Pattern REG_NAME_PART_PATTERN = Pattern.compile("^[a-zA-Z0-9][a-zA-Z0-9-]*$");

    public static String concat(String string, String string2) {
        int n2 = FilenameUtils.getPrefixLength(string2);
        if (n2 < 0) {
            return null;
        }
        if (n2 > 0) {
            return FilenameUtils.normalize(string2);
        }
        if (string == null) {
            return null;
        }
        int n3 = string.length();
        if (n3 == 0) {
            return FilenameUtils.normalize(string2);
        }
        char c2 = string.charAt(n3 - 1);
        if (FilenameUtils.isSeparator(c2)) {
            return FilenameUtils.normalize(string + string2);
        }
        return FilenameUtils.normalize(string + '/' + string2);
    }

    public static boolean directoryContains(String string, String string2) {
        if (FilenameUtils.isEmpty(string) || FilenameUtils.isEmpty(string2)) {
            return false;
        }
        if (IOCase.SYSTEM.checkEquals(string, string2)) {
            return false;
        }
        char c2 = FilenameUtils.toSeparator(string.charAt(0) == '/');
        String string3 = string.charAt(string.length() - 1) == c2 ? string : string + c2;
        return IOCase.SYSTEM.checkStartsWith(string2, string3);
    }

    private static String doGetFullPath(String string, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string);
        if (n2 < 0) {
            return null;
        }
        if (n2 >= string.length()) {
            if (bl2) {
                return FilenameUtils.getPrefix(string);
            }
            return string;
        }
        int n3 = FilenameUtils.indexOfLastSeparator(string);
        if (n3 < 0) {
            return string.substring(0, n2);
        }
        int n4 = n3 + (bl2 ? 1 : 0);
        if (n4 == 0) {
            ++n4;
        }
        return string.substring(0, n4);
    }

    private static String doGetPath(String string, int n2) {
        if (string == null) {
            return null;
        }
        int n3 = FilenameUtils.getPrefixLength(string);
        if (n3 < 0) {
            return null;
        }
        int n4 = FilenameUtils.indexOfLastSeparator(string);
        int n5 = n4 + n2;
        if (n3 >= string.length() || n4 < 0 || n3 >= n5) {
            return EMPTY_STRING;
        }
        return FilenameUtils.requireNonNullChars(string.substring(n3, n5));
    }

    private static String doNormalize(String string, char c2, boolean bl2) {
        int n2;
        int n3;
        if (string == null) {
            return null;
        }
        FilenameUtils.requireNonNullChars(string);
        int n4 = string.length();
        if (n4 == 0) {
            return string;
        }
        int n5 = FilenameUtils.getPrefixLength(string);
        if (n5 < 0) {
            return null;
        }
        char[] cArray = new char[n4 + 2];
        string.getChars(0, string.length(), cArray, 0);
        char c3 = FilenameUtils.flipSeparator(c2);
        for (n3 = 0; n3 < cArray.length; ++n3) {
            if (cArray[n3] != c3) continue;
            cArray[n3] = c2;
        }
        n3 = 1;
        if (cArray[n4 - 1] != c2) {
            cArray[n4++] = c2;
            n3 = 0;
        }
        int n6 = n2 = n5 != 0 ? n5 : 1;
        while (n2 < n4) {
            if (cArray[n2] == c2 && cArray[n2 - 1] == c2) {
                System.arraycopy(cArray, n2, cArray, n2 - 1, n4 - n2);
                --n4;
                --n2;
            }
            ++n2;
        }
        for (n2 = n5 + 1; n2 < n4; ++n2) {
            if (cArray[n2] != c2 || cArray[n2 - 1] != '.' || n2 != n5 + 1 && cArray[n2 - 2] != c2) continue;
            if (n2 == n4 - 1) {
                n3 = 1;
            }
            System.arraycopy(cArray, n2 + 1, cArray, n2 - 1, n4 - n2);
            n4 -= 2;
            --n2;
        }
        block3: for (n2 = n5 + 2; n2 < n4; ++n2) {
            if (cArray[n2] != c2 || cArray[n2 - 1] != '.' || cArray[n2 - 2] != '.' || n2 != n5 + 2 && cArray[n2 - 3] != c2) continue;
            if (n2 == n5 + 2) {
                return null;
            }
            if (n2 == n4 - 1) {
                n3 = 1;
            }
            for (int i2 = n2 - 4; i2 >= n5; --i2) {
                if (cArray[i2] != c2) continue;
                System.arraycopy(cArray, n2 + 1, cArray, i2 + 1, n4 - n2);
                n4 -= n2 - i2;
                n2 = i2 + 1;
                continue block3;
            }
            System.arraycopy(cArray, n2 + 1, cArray, n5, n4 - n2);
            n4 -= n2 + 1 - n5;
            n2 = n5 + 1;
        }
        if (n4 <= 0) {
            return EMPTY_STRING;
        }
        if (n4 <= n5) {
            return new String(cArray, 0, n4);
        }
        if (n3 != 0 && bl2) {
            return new String(cArray, 0, n4);
        }
        return new String(cArray, 0, n4 - 1);
    }

    public static boolean equals(String string, String string2) {
        return FilenameUtils.equals(string, string2, false, IOCase.SENSITIVE);
    }

    public static boolean equals(String string, String string2, boolean bl2, IOCase iOCase) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        if (bl2) {
            if ((string = FilenameUtils.normalize(string)) == null) {
                return false;
            }
            if ((string2 = FilenameUtils.normalize(string2)) == null) {
                return false;
            }
        }
        return IOCase.value(iOCase, IOCase.SENSITIVE).checkEquals(string, string2);
    }

    public static boolean equalsNormalized(String string, String string2) {
        return FilenameUtils.equals(string, string2, true, IOCase.SENSITIVE);
    }

    public static boolean equalsNormalizedOnSystem(String string, String string2) {
        return FilenameUtils.equals(string, string2, true, IOCase.SYSTEM);
    }

    public static boolean equalsOnSystem(String string, String string2) {
        return FilenameUtils.equals(string, string2, false, IOCase.SYSTEM);
    }

    static char flipSeparator(char c2) {
        if (c2 == '/') {
            return '\\';
        }
        if (c2 == '\\') {
            return '/';
        }
        throw new IllegalArgumentException(String.valueOf(c2));
    }

    private static int getAdsCriticalOffset(String string) {
        int n2 = string.lastIndexOf(SYSTEM_NAME_SEPARATOR);
        int n3 = string.lastIndexOf(OTHER_SEPARATOR);
        if (n2 == -1) {
            if (n3 == -1) {
                return 0;
            }
            return n3 + 1;
        }
        if (n3 == -1) {
            return n2 + 1;
        }
        return Math.max(n2, n3) + 1;
    }

    public static String getBaseName(String string) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(string));
    }

    public static String getExtension(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.indexOfExtension(string);
        if (n2 == -1) {
            return EMPTY_STRING;
        }
        return string.substring(n2 + 1);
    }

    public static String getFullPath(String string) {
        return FilenameUtils.doGetFullPath(string, true);
    }

    public static String getFullPathNoEndSeparator(String string) {
        return FilenameUtils.doGetFullPath(string, false);
    }

    public static String getName(String string) {
        if (string == null) {
            return null;
        }
        return FilenameUtils.requireNonNullChars(string).substring(FilenameUtils.indexOfLastSeparator(string) + 1);
    }

    public static String getPath(String string) {
        return FilenameUtils.doGetPath(string, 1);
    }

    public static String getPathNoEndSeparator(String string) {
        return FilenameUtils.doGetPath(string, 0);
    }

    public static String getPrefix(String string) {
        if (string == null) {
            return null;
        }
        int n2 = FilenameUtils.getPrefixLength(string);
        if (n2 < 0) {
            return null;
        }
        if (n2 > string.length()) {
            FilenameUtils.requireNonNullChars(string);
            return string + '/';
        }
        return FilenameUtils.requireNonNullChars(string.substring(0, n2));
    }

    public static int getPrefixLength(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        char c2 = string.charAt(0);
        if (c2 == ':') {
            return -1;
        }
        if (n2 == 1) {
            if (c2 == '~') {
                return 2;
            }
            return FilenameUtils.isSeparator(c2) ? 1 : 0;
        }
        if (c2 == '~') {
            int n3 = string.indexOf(47, 1);
            int n4 = string.indexOf(92, 1);
            if (n3 == -1 && n4 == -1) {
                return n2 + 1;
            }
            n3 = n3 == -1 ? n4 : n3;
            n4 = n4 == -1 ? n3 : n4;
            return Math.min(n3, n4) + 1;
        }
        char c3 = string.charAt(1);
        if (c3 == ':') {
            if ((c2 = Character.toUpperCase(c2)) >= 'A' && c2 <= 'Z') {
                if (n2 == 2 && !FileSystem.getCurrent().supportsDriveLetter()) {
                    return 0;
                }
                if (n2 == 2 || !FilenameUtils.isSeparator(string.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            if (c2 == '/') {
                return 1;
            }
            return -1;
        }
        if (!FilenameUtils.isSeparator(c2) || !FilenameUtils.isSeparator(c3)) {
            return FilenameUtils.isSeparator(c2) ? 1 : 0;
        }
        int n5 = string.indexOf(47, 2);
        int n6 = string.indexOf(92, 2);
        if (n5 == -1 && n6 == -1 || n5 == 2 || n6 == 2) {
            return -1;
        }
        n5 = n5 == -1 ? n6 : n5;
        n6 = n6 == -1 ? n5 : n6;
        int n7 = Math.min(n5, n6) + 1;
        String string2 = string.substring(2, n7 - 1);
        return FilenameUtils.isValidHostName(string2) ? n7 : -1;
    }

    public static int indexOfExtension(String string) {
        int n2;
        if (string == null) {
            return -1;
        }
        if (FilenameUtils.isSystemWindows() && (n2 = string.indexOf(58, FilenameUtils.getAdsCriticalOffset(string))) != -1) {
            throw new IllegalArgumentException("NTFS ADS separator (':') in file name is forbidden.");
        }
        n2 = string.lastIndexOf(46);
        int n3 = FilenameUtils.indexOfLastSeparator(string);
        return n3 > n2 ? -1 : n2;
    }

    public static int indexOfLastSeparator(String string) {
        if (string == null) {
            return -1;
        }
        int n2 = string.lastIndexOf(47);
        int n3 = string.lastIndexOf(92);
        return Math.max(n2, n3);
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isExtension(String string, Collection collection) {
        if (string == null) {
            return false;
        }
        FilenameUtils.requireNonNullChars(string);
        if (collection == null || collection.isEmpty()) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        return collection.contains(FilenameUtils.getExtension(string));
    }

    public static boolean isExtension(String string, String string2) {
        if (string == null) {
            return false;
        }
        FilenameUtils.requireNonNullChars(string);
        if (FilenameUtils.isEmpty(string2)) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        return FilenameUtils.getExtension(string).equals(string2);
    }

    public static boolean isExtension(String string, String ... stringArray) {
        if (string == null) {
            return false;
        }
        FilenameUtils.requireNonNullChars(string);
        if (stringArray == null || stringArray.length == 0) {
            return FilenameUtils.indexOfExtension(string) == -1;
        }
        String string2 = FilenameUtils.getExtension(string);
        return Stream.of(stringArray).anyMatch(string2::equals);
    }

    private static boolean isIPv4Address(String string) {
        Matcher matcher = IPV4_PATTERN.matcher(string);
        if (!matcher.matches() || matcher.groupCount() != 4) {
            return false;
        }
        for (int i2 = 1; i2 <= 4; ++i2) {
            String string2 = matcher.group(i2);
            int n2 = Integer.parseInt(string2);
            if (n2 > 255) {
                return false;
            }
            if (string2.length() <= 1 || !string2.startsWith("0")) continue;
            return false;
        }
        return true;
    }

    private static boolean isIPv6Address(String string) {
        boolean bl2 = string.contains("::");
        if (bl2 && string.indexOf("::") != string.lastIndexOf("::")) {
            return false;
        }
        if (string.startsWith(":") && !string.startsWith("::") || string.endsWith(":") && !string.endsWith("::")) {
            return false;
        }
        String[] stringArray = string.split(":");
        if (bl2) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            if (string.endsWith("::")) {
                arrayList.add(EMPTY_STRING);
            } else if (string.startsWith("::") && !arrayList.isEmpty()) {
                arrayList.remove(0);
            }
            stringArray = arrayList.toArray(EMPTY_STRING_ARRAY);
        }
        if (stringArray.length > 8) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2];
            if (string2.isEmpty()) {
                if (++n3 > 1) {
                    return false;
                }
            } else {
                int n4;
                n3 = 0;
                if (i2 == stringArray.length - 1 && string2.contains(".")) {
                    if (!FilenameUtils.isIPv4Address(string2)) {
                        return false;
                    }
                    n2 += 2;
                    continue;
                }
                if (string2.length() > 4) {
                    return false;
                }
                try {
                    n4 = Integer.parseInt(string2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (n4 < 0 || n4 > 65535) {
                    return false;
                }
            }
            ++n2;
        }
        return n2 <= 8 && (n2 >= 8 || bl2);
    }

    private static boolean isRFC3986HostName(String string) {
        String[] stringArray = string.split("\\.", -1);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].isEmpty()) {
                return i2 == stringArray.length - 1;
            }
            if (REG_NAME_PART_PATTERN.matcher(stringArray[i2]).matches()) continue;
            return false;
        }
        return true;
    }

    private static boolean isSeparator(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    static boolean isSystemWindows() {
        return SYSTEM_NAME_SEPARATOR == '\\';
    }

    private static boolean isValidHostName(String string) {
        return FilenameUtils.isIPv6Address(string) || FilenameUtils.isRFC3986HostName(string);
    }

    public static String normalize(String string) {
        return FilenameUtils.doNormalize(string, SYSTEM_NAME_SEPARATOR, true);
    }

    public static String normalize(String string, boolean bl2) {
        return FilenameUtils.doNormalize(string, FilenameUtils.toSeparator(bl2), true);
    }

    public static String normalizeNoEndSeparator(String string) {
        return FilenameUtils.doNormalize(string, SYSTEM_NAME_SEPARATOR, false);
    }

    public static String normalizeNoEndSeparator(String string, boolean bl2) {
        return FilenameUtils.doNormalize(string, FilenameUtils.toSeparator(bl2), false);
    }

    public static String removeExtension(String string) {
        if (string == null) {
            return null;
        }
        FilenameUtils.requireNonNullChars(string);
        int n2 = FilenameUtils.indexOfExtension(string);
        if (n2 == -1) {
            return string;
        }
        return string.substring(0, n2);
    }

    private static String requireNonNullChars(String string) {
        if (string.indexOf(0) >= 0) {
            throw new IllegalArgumentException("Null character present in file/path name. There are no known legitimate use cases for such data, but several injection attacks may use it");
        }
        return string;
    }

    public static String separatorsToSystem(String string) {
        return FileSystem.getCurrent().normalizeSeparators(string);
    }

    public static String separatorsToUnix(String string) {
        return FileSystem.LINUX.normalizeSeparators(string);
    }

    public static String separatorsToWindows(String string) {
        return FileSystem.WINDOWS.normalizeSeparators(string);
    }

    static String[] splitOnTokens(String string) {
        if (string.indexOf(63) == -1 && string.indexOf(42) == -1) {
            return new String[]{string};
        }
        char[] cArray = string.toCharArray();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        char c2 = '\u0000';
        for (char c3 : cArray) {
            if (c3 == '?' || c3 == '*') {
                if (stringBuilder.length() != 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                }
                if (c3 == '?') {
                    arrayList.add("?");
                } else if (c2 != '*') {
                    arrayList.add("*");
                }
            } else {
                stringBuilder.append(c3);
            }
            c2 = c3;
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        return arrayList.toArray(EMPTY_STRING_ARRAY);
    }

    private static char toSeparator(boolean bl2) {
        return bl2 ? (char)'/' : '\\';
    }

    public static boolean wildcardMatch(String string, String string2) {
        return FilenameUtils.wildcardMatch(string, string2, IOCase.SENSITIVE);
    }

    public static boolean wildcardMatch(String string, String string2, IOCase iOCase) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        iOCase = IOCase.value(iOCase, IOCase.SENSITIVE);
        String[] stringArray = FilenameUtils.splitOnTokens(string2);
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        ArrayDeque<int[]> arrayDeque = new ArrayDeque<int[]>(stringArray.length);
        do {
            if (!arrayDeque.isEmpty()) {
                int[] nArray = (int[])arrayDeque.pop();
                n3 = nArray[0];
                n2 = nArray[1];
                bl2 = true;
            }
            while (n3 < stringArray.length) {
                if (stringArray[n3].equals("?")) {
                    if (++n2 > string.length()) break;
                    bl2 = false;
                } else if (stringArray[n3].equals("*")) {
                    bl2 = true;
                    if (n3 == stringArray.length - 1) {
                        n2 = string.length();
                    }
                } else {
                    if (bl2) {
                        if ((n2 = iOCase.checkIndexOf(string, n2, stringArray[n3])) == -1) break;
                        int n4 = iOCase.checkIndexOf(string, n2 + 1, stringArray[n3]);
                        if (n4 >= 0) {
                            arrayDeque.push(new int[]{n3, n4});
                        }
                    } else if (!iOCase.checkRegionMatches(string, n2, stringArray[n3])) break;
                    n2 += stringArray[n3].length();
                    bl2 = false;
                }
                ++n3;
            }
            if (n3 != stringArray.length || n2 != string.length()) continue;
            return true;
        } while (!arrayDeque.isEmpty());
        return false;
    }

    public static boolean wildcardMatchOnSystem(String string, String string2) {
        return FilenameUtils.wildcardMatch(string, string2, IOCase.SYSTEM);
    }

    @Deprecated
    public FilenameUtils() {
    }
}

