/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.CloseableURLConnection;
import org.apache.commons.io.FileExistsException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.StreamIterator;
import org.apache.commons.io.file.AccumulatorPathVisitor;
import org.apache.commons.io.file.Counters;
import org.apache.commons.io.file.Counters$PathCounters;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.file.StandardDeleteOption;
import org.apache.commons.io.filefilter.FileEqualsFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.Uncheck;

public class FileUtils {
    private static final String PROTOCOL_FILE = "file";
    public static final long ONE_KB = 1024L;
    public static final BigInteger ONE_KB_BI = BigInteger.valueOf(1024L);
    public static final long ONE_MB = 0x100000L;
    public static final BigInteger ONE_MB_BI = ONE_KB_BI.multiply(ONE_KB_BI);
    public static final long ONE_GB = 0x40000000L;
    public static final BigInteger ONE_GB_BI = ONE_KB_BI.multiply(ONE_MB_BI);
    public static final long ONE_TB = 0x10000000000L;
    public static final BigInteger ONE_TB_BI = ONE_KB_BI.multiply(ONE_GB_BI);
    public static final long ONE_PB = 0x4000000000000L;
    public static final BigInteger ONE_PB_BI = ONE_KB_BI.multiply(ONE_TB_BI);
    public static final long ONE_EB = 0x1000000000000000L;
    public static final BigInteger ONE_EB_BI = ONE_KB_BI.multiply(ONE_PB_BI);
    public static final BigInteger ONE_ZB = BigInteger.valueOf(1024L).multiply(BigInteger.valueOf(0x1000000000000000L));
    public static final BigInteger ONE_YB = ONE_KB_BI.multiply(ONE_ZB);
    public static final File[] EMPTY_FILE_ARRAY = new File[0];

    public static String byteCountToDisplaySize(BigInteger bigInteger) {
        Objects.requireNonNull(bigInteger, "size");
        String string = bigInteger.divide(ONE_EB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_EB_BI) + " EB" : (bigInteger.divide(ONE_PB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_PB_BI) + " PB" : (bigInteger.divide(ONE_TB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_TB_BI) + " TB" : (bigInteger.divide(ONE_GB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_GB_BI) + " GB" : (bigInteger.divide(ONE_MB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_MB_BI) + " MB" : (bigInteger.divide(ONE_KB_BI).compareTo(BigInteger.ZERO) > 0 ? bigInteger.divide(ONE_KB_BI) + " KB" : bigInteger + " bytes")))));
        return string;
    }

    public static String byteCountToDisplaySize(long l2) {
        return FileUtils.byteCountToDisplaySize(BigInteger.valueOf(l2));
    }

    public static String byteCountToDisplaySize(Number number) {
        return FileUtils.byteCountToDisplaySize(number.longValue());
    }

    private static void checkExists(File file, boolean bl2) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        if (bl2 && !file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
    }

    private static void checkFileExists(File file, String string) {
        Objects.requireNonNull(file, string);
        if (!file.isFile()) {
            if (file.exists()) {
                throw new IllegalArgumentException("Parameter '" + string + "' is not a file: " + file);
            }
            if (!Files.isSymbolicLink(file.toPath())) {
                throw new FileNotFoundException("Source '" + file + "' does not exist");
            }
        }
    }

    private static File checkIsFile(File file, String string) {
        if (file.isFile()) {
            return file;
        }
        throw new IllegalArgumentException(String.format("Parameter '%s' is not a file: %s", string, file));
    }

    public static Checksum checksum(File file, Checksum checksum) {
        FileUtils.checkFileExists(file, PROTOCOL_FILE);
        Objects.requireNonNull(checksum, "checksum");
        try (CheckedInputStream checkedInputStream = new CheckedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]), checksum);){
            IOUtils.consume(checkedInputStream);
        }
        return checksum;
    }

    public static long checksumCRC32(File file) {
        return FileUtils.checksum(file, new CRC32()).getValue();
    }

    public static void cleanDirectory(File file2) {
        IOConsumer.forAll(file -> FileUtils.forceDelete(file, false), FileUtils.listFiles(file2, null));
    }

    private static void cleanDirectoryOnExit(File file) {
        IOConsumer.forAll(FileUtils::forceDeleteOnExit, FileUtils.listFiles(file, null));
    }

    public static boolean contentEquals(File file, File file2) {
        if (file == null && file2 == null) {
            return true;
        }
        if (file == null || file2 == null) {
            return false;
        }
        boolean bl2 = file.exists();
        if (bl2 != file2.exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        FileUtils.checkIsFile(file, "file1");
        FileUtils.checkIsFile(file2, "file2");
        if (file.length() != file2.length()) {
            return false;
        }
        if (file.getCanonicalFile().equals(file2.getCanonicalFile())) {
            return true;
        }
        return PathUtils.fileContentEquals(file.toPath(), file2.toPath());
    }

    public static boolean contentEqualsIgnoreEOL(File file, File file2, String string) {
        if (file == null && file2 == null) {
            return true;
        }
        if (file == null || file2 == null) {
            return false;
        }
        boolean bl2 = file.exists();
        if (bl2 != file2.exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        FileUtils.checkFileExists(file, "file1");
        FileUtils.checkFileExists(file2, "file2");
        if (file.getCanonicalFile().equals(file2.getCanonicalFile())) {
            return true;
        }
        Charset charset = Charsets.toCharset(string);
        try (InputStreamReader inputStreamReader = new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), charset);){
            boolean bl3;
            try (InputStreamReader inputStreamReader2 = new InputStreamReader(Files.newInputStream(file2.toPath(), new OpenOption[0]), charset);){
                bl3 = IOUtils.contentEqualsIgnoreEOL(inputStreamReader, inputStreamReader2);
            }
            return bl3;
        }
    }

    public static File[] convertFileCollectionToFileArray(Collection collection) {
        return collection.toArray(EMPTY_FILE_ARRAY);
    }

    public static void copyDirectory(File file, File file2) {
        FileUtils.copyDirectory(file, file2, true);
    }

    public static void copyDirectory(File file, File file2, boolean bl2) {
        FileUtils.copyDirectory(file, file2, null, bl2);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter) {
        FileUtils.copyDirectory(file, file2, fileFilter, true);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl2) {
        FileUtils.copyDirectory(file, file2, fileFilter, bl2, StandardCopyOption.REPLACE_EXISTING, LinkOption.NOFOLLOW_LINKS);
    }

    public static void copyDirectory(File file, File file2, FileFilter fileFilter, boolean bl2, CopyOption ... copyOptionArray) {
        File[] fileArray;
        Objects.requireNonNull(file2, "destination");
        FileUtils.requireDirectoryExists(file, "srcDir");
        FileUtils.requireCanonicalPathsNotEquals(file, file2);
        ArrayList<String> arrayList = null;
        String string = file.getCanonicalPath();
        String string2 = file2.getCanonicalPath();
        if (string2.startsWith(string) && (fileArray = FileUtils.listFiles(file, fileFilter)).length > 0) {
            arrayList = new ArrayList<String>(fileArray.length);
            for (File file3 : fileArray) {
                arrayList.add(new File(file2, file3.getName()).getCanonicalPath());
            }
        }
        FileUtils.doCopyDirectory(file, file2, fileFilter, arrayList, bl2, copyOptionArray);
    }

    public static void copyDirectoryToDirectory(File file, File file2) {
        Objects.requireNonNull(file, "sourceDir");
        FileUtils.requireDirectoryIfExists(file2, "destinationDir");
        FileUtils.copyDirectory(file, new File(file2, file.getName()), true);
    }

    public static void copyFile(File file, File file2) {
        FileUtils.copyFile(file, file2, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File file, File file2, boolean bl2) {
        FileUtils.copyFile(file, file2, bl2, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File file, File file2, boolean bl2, CopyOption ... copyOptionArray) {
        Objects.requireNonNull(file2, "destination");
        FileUtils.checkFileExists(file, "srcFile");
        FileUtils.requireCanonicalPathsNotEquals(file, file2);
        FileUtils.createParentDirectories(file2);
        if (file2.exists()) {
            FileUtils.checkFileExists(file2, "destFile");
        }
        Path path = file.toPath();
        Files.copy(path, file2.toPath(), copyOptionArray);
        if (bl2 && !Files.isSymbolicLink(path) && !FileUtils.setTimes(file, file2)) {
            throw new IOException("Cannot set the file time.");
        }
    }

    public static void copyFile(File file, File file2, CopyOption ... copyOptionArray) {
        FileUtils.copyFile(file, file2, true, copyOptionArray);
    }

    public static long copyFile(File file, OutputStream outputStream) {
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            long l2 = IOUtils.copyLarge(inputStream, outputStream);
            return l2;
        }
    }

    public static void copyFileToDirectory(File file, File file2) {
        FileUtils.copyFileToDirectory(file, file2, true);
    }

    public static void copyFileToDirectory(File file, File file2, boolean bl2) {
        Objects.requireNonNull(file, "sourceFile");
        FileUtils.requireDirectoryIfExists(file2, "destinationDir");
        FileUtils.copyFile(file, new File(file2, file.getName()), bl2);
    }

    public static void copyInputStreamToFile(InputStream inputStream, File file) {
        try (InputStream inputStream2 = inputStream;){
            FileUtils.copyToFile(inputStream2, file);
        }
    }

    public static void copyToDirectory(File file, File file2) {
        Objects.requireNonNull(file, "sourceFile");
        if (file.isFile()) {
            FileUtils.copyFileToDirectory(file, file2);
        } else if (file.isDirectory()) {
            FileUtils.copyDirectoryToDirectory(file, file2);
        } else {
            throw new FileNotFoundException("The source " + file + " does not exist");
        }
    }

    public static void copyToDirectory(Iterable iterable, File file) {
        Objects.requireNonNull(iterable, "sourceIterable");
        for (File file2 : iterable) {
            FileUtils.copyFileToDirectory(file2, file);
        }
    }

    public static void copyToFile(InputStream inputStream, File file) {
        try (OutputStream outputStream = FileUtils.newOutputStream(file, false);){
            IOUtils.copy(inputStream, outputStream);
        }
    }

    public static void copyURLToFile(URL uRL, File file) {
        Path path = file.toPath();
        PathUtils.createParentDirectories(path, new FileAttribute[0]);
        PathUtils.copy(uRL::openStream, path, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyURLToFile(URL uRL, File file, int n2, int n3) {
        try (CloseableURLConnection closeableURLConnection = CloseableURLConnection.open(uRL);){
            closeableURLConnection.setConnectTimeout(n2);
            closeableURLConnection.setReadTimeout(n3);
            try (InputStream inputStream = closeableURLConnection.getInputStream();){
                FileUtils.copyInputStreamToFile(inputStream, file);
            }
        }
    }

    public static File createParentDirectories(File file) {
        return FileUtils.mkdirs(FileUtils.getParentFile(file));
    }

    public static File current() {
        return PathUtils.current().toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String decodeUrl(String string) {
        String string2 = string;
        if (string != null && string.indexOf(37) >= 0) {
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder();
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
            int n3 = 0;
            while (n3 < n2) {
                if (string.charAt(n3) == '%') {
                    try {
                        do {
                            byte by = (byte)Integer.parseInt(string.substring(n3 + 1, n3 + 3), 16);
                            byteBuffer.put(by);
                        } while ((n3 += 3) < n2 && string.charAt(n3) == '%');
                        continue;
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {
                    }
                    finally {
                        if (byteBuffer.position() <= 0) continue;
                        byteBuffer.flip();
                        stringBuilder.append(StandardCharsets.UTF_8.decode(byteBuffer).toString());
                        byteBuffer.clear();
                        continue;
                    }
                }
                stringBuilder.append(string.charAt(n3++));
            }
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public static File delete(File file) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        Files.delete(file.toPath());
        return file;
    }

    public static void deleteDirectory(File file) {
        Objects.requireNonNull(file, "directory");
        if (!file.exists()) {
            return;
        }
        if (!FileUtils.isSymlink(file)) {
            FileUtils.cleanDirectory(file);
        }
        FileUtils.delete(file);
    }

    private static void deleteDirectoryOnExit(File file) {
        if (!file.exists()) {
            return;
        }
        file.deleteOnExit();
        if (!FileUtils.isSymlink(file)) {
            FileUtils.cleanDirectoryOnExit(file);
        }
    }

    public static boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            if (file.isDirectory()) {
                FileUtils.cleanDirectory(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean directoryContains(File file, File file2) {
        FileUtils.requireDirectoryExists(file, "directory");
        if (file2 == null || !file2.exists()) {
            return false;
        }
        return FilenameUtils.directoryContains(file.getCanonicalPath(), file2.getCanonicalPath());
    }

    private static void doCopyDirectory(File file, File file2, FileFilter fileFilter, List list, boolean bl2, CopyOption ... copyOptionArray) {
        File[] fileArray = FileUtils.listFiles(file, fileFilter);
        FileUtils.requireDirectoryIfExists(file2, "destDir");
        FileUtils.mkdirs(file2);
        for (File file3 : fileArray) {
            File file4 = new File(file2, file3.getName());
            if (list != null && list.contains(file3.getCanonicalPath())) continue;
            if (file3.isDirectory()) {
                FileUtils.doCopyDirectory(file3, file4, fileFilter, list, bl2, copyOptionArray);
                continue;
            }
            FileUtils.copyFile(file3, file4, bl2, copyOptionArray);
        }
        if (bl2) {
            FileUtils.setTimes(file, file2);
        }
    }

    public static void forceDelete(File file) {
        FileUtils.forceDelete(file, true);
    }

    private static void forceDelete(File file, boolean bl2) {
        Counters$PathCounters counters$PathCounters;
        FileUtils.checkExists(file, bl2);
        try {
            counters$PathCounters = PathUtils.delete(file.toPath(), PathUtils.EMPTY_LINK_OPTION_ARRAY, StandardDeleteOption.OVERRIDE_READ_ONLY);
        }
        catch (NoSuchFileException noSuchFileException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException("Cannot delete file: " + file);
            fileNotFoundException.initCause(noSuchFileException);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw new IOException("Cannot delete file: " + file, iOException);
        }
        if (counters$PathCounters.getFileCounter().get() < 1L && counters$PathCounters.getDirectoryCounter().get() < 1L) {
            throw new FileNotFoundException("File does not exist: " + file);
        }
    }

    public static void forceDeleteOnExit(File file) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    public static void forceMkdir(File file) {
        FileUtils.mkdirs(file);
    }

    public static void forceMkdirParent(File file) {
        FileUtils.forceMkdir(FileUtils.getParentFile(Objects.requireNonNull(file, PROTOCOL_FILE)));
    }

    public static File getFile(File file, String ... stringArray) {
        Objects.requireNonNull(file, "directory");
        Objects.requireNonNull(stringArray, "names");
        File file2 = file;
        for (String string : stringArray) {
            file2 = new File(file2, string);
        }
        return file2;
    }

    public static File getFile(String ... stringArray) {
        Objects.requireNonNull(stringArray, "names");
        File file = null;
        for (String string : stringArray) {
            file = file == null ? new File(string) : new File(file, string);
        }
        return file;
    }

    private static File getParentFile(File file) {
        return file == null ? null : file.getParentFile();
    }

    public static File getTempDirectory() {
        return new File(FileUtils.getTempDirectoryPath());
    }

    public static String getTempDirectoryPath() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File getUserDirectory() {
        return new File(FileUtils.getUserDirectoryPath());
    }

    public static String getUserDirectoryPath() {
        return System.getProperty("user.home");
    }

    public static boolean isDirectory(File file, LinkOption ... linkOptionArray) {
        return file != null && Files.isDirectory(file.toPath(), linkOptionArray);
    }

    public static boolean isEmptyDirectory(File file) {
        return PathUtils.isEmptyDirectory(file.toPath());
    }

    public static boolean isFileNewer(File file, ChronoLocalDate chronoLocalDate) {
        return FileUtils.isFileNewer(file, chronoLocalDate, LocalTime.MAX);
    }

    public static boolean isFileNewer(File file, ChronoLocalDate chronoLocalDate, LocalTime localTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(localTime, "localTime");
        return FileUtils.isFileNewer(file, chronoLocalDate.atTime(localTime));
    }

    public static boolean isFileNewer(File file, ChronoLocalDate chronoLocalDate, OffsetTime offsetTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(offsetTime, "offsetTime");
        return FileUtils.isFileNewer(file, chronoLocalDate.atTime(offsetTime.toLocalTime()));
    }

    public static boolean isFileNewer(File file, ChronoLocalDateTime chronoLocalDateTime) {
        return FileUtils.isFileNewer(file, chronoLocalDateTime, ZoneId.systemDefault());
    }

    public static boolean isFileNewer(File file, ChronoLocalDateTime chronoLocalDateTime, ZoneId zoneId) {
        Objects.requireNonNull(chronoLocalDateTime, "chronoLocalDateTime");
        Objects.requireNonNull(zoneId, "zoneId");
        return FileUtils.isFileNewer(file, chronoLocalDateTime.atZone(zoneId));
    }

    public static boolean isFileNewer(File file, ChronoZonedDateTime chronoZonedDateTime) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        Objects.requireNonNull(chronoZonedDateTime, "chronoZonedDateTime");
        return (Boolean)Uncheck.get(() -> PathUtils.isNewer(file.toPath(), chronoZonedDateTime, new LinkOption[0]));
    }

    public static boolean isFileNewer(File file, Date date) {
        Objects.requireNonNull(date, "date");
        return FileUtils.isFileNewer(file, date.getTime());
    }

    public static boolean isFileNewer(File file, File file2) {
        return (Boolean)Uncheck.get(() -> PathUtils.isNewer(file.toPath(), file2.toPath()));
    }

    public static boolean isFileNewer(File file, FileTime fileTime) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return PathUtils.isNewer(file.toPath(), fileTime, new LinkOption[0]);
    }

    public static boolean isFileNewer(File file, Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return (Boolean)Uncheck.get(() -> PathUtils.isNewer(file.toPath(), instant, new LinkOption[0]));
    }

    public static boolean isFileNewer(File file, long l2) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return (Boolean)Uncheck.get(() -> PathUtils.isNewer(file.toPath(), l2, new LinkOption[0]));
    }

    public static boolean isFileNewer(File file, OffsetDateTime offsetDateTime) {
        Objects.requireNonNull(offsetDateTime, "offsetDateTime");
        return FileUtils.isFileNewer(file, offsetDateTime.toInstant());
    }

    public static boolean isFileOlder(File file, ChronoLocalDate chronoLocalDate) {
        return FileUtils.isFileOlder(file, chronoLocalDate, LocalTime.MAX);
    }

    public static boolean isFileOlder(File file, ChronoLocalDate chronoLocalDate, LocalTime localTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(localTime, "localTime");
        return FileUtils.isFileOlder(file, chronoLocalDate.atTime(localTime));
    }

    public static boolean isFileOlder(File file, ChronoLocalDate chronoLocalDate, OffsetTime offsetTime) {
        Objects.requireNonNull(chronoLocalDate, "chronoLocalDate");
        Objects.requireNonNull(offsetTime, "offsetTime");
        return FileUtils.isFileOlder(file, chronoLocalDate.atTime(offsetTime.toLocalTime()));
    }

    public static boolean isFileOlder(File file, ChronoLocalDateTime chronoLocalDateTime) {
        return FileUtils.isFileOlder(file, chronoLocalDateTime, ZoneId.systemDefault());
    }

    public static boolean isFileOlder(File file, ChronoLocalDateTime chronoLocalDateTime, ZoneId zoneId) {
        Objects.requireNonNull(chronoLocalDateTime, "chronoLocalDateTime");
        Objects.requireNonNull(zoneId, "zoneId");
        return FileUtils.isFileOlder(file, chronoLocalDateTime.atZone(zoneId));
    }

    public static boolean isFileOlder(File file, ChronoZonedDateTime chronoZonedDateTime) {
        Objects.requireNonNull(chronoZonedDateTime, "chronoZonedDateTime");
        return FileUtils.isFileOlder(file, chronoZonedDateTime.toInstant());
    }

    public static boolean isFileOlder(File file, Date date) {
        Objects.requireNonNull(date, "date");
        return FileUtils.isFileOlder(file, date.getTime());
    }

    public static boolean isFileOlder(File file, File file2) {
        return (Boolean)Uncheck.get(() -> PathUtils.isOlder(file.toPath(), file2.toPath()));
    }

    public static boolean isFileOlder(File file, FileTime fileTime) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return PathUtils.isOlder(file.toPath(), fileTime, new LinkOption[0]);
    }

    public static boolean isFileOlder(File file, Instant instant) {
        Objects.requireNonNull(instant, "instant");
        return (Boolean)Uncheck.get(() -> PathUtils.isOlder(file.toPath(), instant, new LinkOption[0]));
    }

    public static boolean isFileOlder(File file, long l2) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return (Boolean)Uncheck.get(() -> PathUtils.isOlder(file.toPath(), l2, new LinkOption[0]));
    }

    public static boolean isFileOlder(File file, OffsetDateTime offsetDateTime) {
        Objects.requireNonNull(offsetDateTime, "offsetDateTime");
        return FileUtils.isFileOlder(file, offsetDateTime.toInstant());
    }

    private static boolean isFileProtocol(URL uRL) {
        return PROTOCOL_FILE.equalsIgnoreCase(uRL.getProtocol());
    }

    public static boolean isRegularFile(File file, LinkOption ... linkOptionArray) {
        return file != null && Files.isRegularFile(file.toPath(), linkOptionArray);
    }

    public static boolean isSymlink(File file) {
        return file != null && Files.isSymbolicLink(file.toPath());
    }

    public static Iterator iterateFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFiles(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static Iterator iterateFiles(File file, String[] stringArray, boolean bl2) {
        return StreamIterator.iterator((Stream)Uncheck.get(() -> FileUtils.streamFiles(file, bl2, stringArray)));
    }

    public static Iterator iterateFilesAndDirs(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        return FileUtils.listFilesAndDirs(file, iOFileFilter, iOFileFilter2).iterator();
    }

    public static long lastModified(File file) {
        return FileUtils.lastModifiedFileTime(file).toMillis();
    }

    public static FileTime lastModifiedFileTime(File file) {
        return Files.getLastModifiedTime(Objects.requireNonNull(file, PROTOCOL_FILE).toPath(), new LinkOption[0]);
    }

    public static long lastModifiedUnchecked(File file) {
        return (Long)Uncheck.apply(FileUtils::lastModified, file);
    }

    public static LineIterator lineIterator(File file) {
        return FileUtils.lineIterator(file, null);
    }

    public static LineIterator lineIterator(File file, String string) {
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
            return IOUtils.lineIterator(inputStream, string);
        }
        catch (IOException | RuntimeException exception) {
            IOUtils.closeQuietly((Closeable)inputStream, exception::addSuppressed);
            throw exception;
        }
    }

    private static AccumulatorPathVisitor listAccumulate(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2, FileVisitOption ... fileVisitOptionArray) {
        boolean bl2 = iOFileFilter2 != null;
        FileEqualsFileFilter fileEqualsFileFilter = new FileEqualsFileFilter(file);
        FileEqualsFileFilter fileEqualsFileFilter2 = bl2 ? fileEqualsFileFilter.or(iOFileFilter2) : fileEqualsFileFilter;
        AccumulatorPathVisitor accumulatorPathVisitor = new AccumulatorPathVisitor(Counters.noopPathCounters(), iOFileFilter, fileEqualsFileFilter2, (path, iOException) -> FileVisitResult.CONTINUE);
        HashSet<FileVisitOption> hashSet = new HashSet<FileVisitOption>();
        if (fileVisitOptionArray != null) {
            Collections.addAll(hashSet, fileVisitOptionArray);
        }
        Files.walkFileTree(file.toPath(), hashSet, FileUtils.toMaxDepth(bl2), accumulatorPathVisitor);
        return accumulatorPathVisitor;
    }

    private static File[] listFiles(File file, FileFilter fileFilter) {
        FileUtils.requireDirectoryExists(file, "directory");
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null) {
            throw new IOException("Unknown I/O error listing contents of directory: " + file);
        }
        return fileArray;
    }

    public static Collection listFiles(File file2, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        AccumulatorPathVisitor accumulatorPathVisitor = (AccumulatorPathVisitor)Uncheck.apply(file -> FileUtils.listAccumulate(file, FileFileFilter.INSTANCE.and(iOFileFilter), iOFileFilter2, FileVisitOption.FOLLOW_LINKS), file2);
        return FileUtils.toList(accumulatorPathVisitor.getFileList().stream().map(Path::toFile));
    }

    private static void listFiles(File file3, List list, boolean bl2, FilenameFilter filenameFilter) {
        File[] fileArray = file3.listFiles();
        if (fileArray != null) {
            ArrayList arrayList = bl2 ? new ArrayList() : null;
            Arrays.stream(fileArray).forEach(file2 -> {
                if (bl2 && file2.isDirectory()) {
                    arrayList.add(file2);
                } else if (file2.isFile() && filenameFilter.accept(file3, file2.getName())) {
                    list.add(file2);
                }
            });
            if (bl2) {
                arrayList.forEach(file -> FileUtils.listFiles(file, list, true, filenameFilter));
            }
        }
    }

    public static Collection listFiles(File file, String[] stringArray, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        IOFileFilter iOFileFilter = stringArray != null ? FileUtils.toSuffixFileFilter(stringArray) : TrueFileFilter.INSTANCE;
        FileUtils.listFiles(file, arrayList, bl2, iOFileFilter);
        return arrayList;
    }

    public static Collection listFilesAndDirs(File file2, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        AccumulatorPathVisitor accumulatorPathVisitor = (AccumulatorPathVisitor)Uncheck.apply(file -> FileUtils.listAccumulate(file, iOFileFilter, iOFileFilter2, FileVisitOption.FOLLOW_LINKS), file2);
        List list = accumulatorPathVisitor.getFileList();
        list.addAll(accumulatorPathVisitor.getDirList());
        return FileUtils.toList(list.stream().map(Path::toFile));
    }

    private static File mkdirs(File file) {
        if (file != null && !file.mkdirs() && !file.isDirectory()) {
            throw new IOException("Cannot create directory '" + file + "'.");
        }
        return file;
    }

    public static void moveDirectory(File file, File file2) {
        Objects.requireNonNull(file2, "destination");
        FileUtils.requireDirectoryExists(file, "srcDir");
        FileUtils.requireAbsent(file2, "destDir");
        if (!file.renameTo(file2)) {
            if (file2.getCanonicalPath().startsWith(file.getCanonicalPath() + File.separator)) {
                throw new IOException("Cannot move directory: " + file + " to a subdirectory of itself: " + file2);
            }
            FileUtils.copyDirectory(file, file2);
            FileUtils.deleteDirectory(file);
            if (file.exists()) {
                throw new IOException("Failed to delete original directory '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void moveDirectoryToDirectory(File file, File file2, boolean bl2) {
        FileUtils.validateMoveParameters(file, file2);
        if (!file2.isDirectory()) {
            if (file2.exists()) {
                throw new IOException("Destination '" + file2 + "' is not a directory");
            }
            if (!bl2) {
                throw new FileNotFoundException("Destination directory '" + file2 + "' does not exist [createDestDir=" + false + "]");
            }
            FileUtils.mkdirs(file2);
        }
        FileUtils.moveDirectory(file, new File(file2, file.getName()));
    }

    public static void moveFile(File file, File file2) {
        FileUtils.moveFile(file, file2, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static void moveFile(File file, File file2, CopyOption ... copyOptionArray) {
        Objects.requireNonNull(file2, "destination");
        FileUtils.checkFileExists(file, "srcFile");
        FileUtils.requireAbsent(file2, "destFile");
        boolean bl2 = file.renameTo(file2);
        if (!bl2) {
            FileUtils.copyFile(file, file2, false, copyOptionArray);
            if (!file.delete()) {
                FileUtils.deleteQuietly(file2);
                throw new IOException("Failed to delete original file '" + file + "' after copy to '" + file2 + "'");
            }
        }
    }

    public static void moveFileToDirectory(File file, File file2, boolean bl2) {
        FileUtils.validateMoveParameters(file, file2);
        if (!file2.exists() && bl2) {
            FileUtils.mkdirs(file2);
        }
        FileUtils.requireDirectoryExists(file2, "destDir");
        FileUtils.moveFile(file, new File(file2, file.getName()));
    }

    public static void moveToDirectory(File file, File file2, boolean bl2) {
        FileUtils.validateMoveParameters(file, file2);
        if (file.isDirectory()) {
            FileUtils.moveDirectoryToDirectory(file, file2, bl2);
        } else {
            FileUtils.moveFileToDirectory(file, file2, bl2);
        }
    }

    public static OutputStream newOutputStream(File file, boolean bl2) {
        return PathUtils.newOutputStream(Objects.requireNonNull(file, PROTOCOL_FILE).toPath(), bl2);
    }

    public static FileInputStream openInputStream(File file) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return new FileInputStream(file);
    }

    public static FileOutputStream openOutputStream(File file) {
        return FileUtils.openOutputStream(file, false);
    }

    public static FileOutputStream openOutputStream(File file, boolean bl2) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        if (file.exists()) {
            FileUtils.checkIsFile(file, PROTOCOL_FILE);
        } else {
            FileUtils.createParentDirectories(file);
        }
        return new FileOutputStream(file, bl2);
    }

    public static byte[] readFileToByteArray(File file) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return Files.readAllBytes(file.toPath());
    }

    @Deprecated
    public static String readFileToString(File file) {
        return FileUtils.readFileToString(file, Charset.defaultCharset());
    }

    public static String readFileToString(File file, Charset charset) {
        return IOUtils.toString(() -> Files.newInputStream(file.toPath(), new OpenOption[0]), Charsets.toCharset(charset));
    }

    public static String readFileToString(File file, String string) {
        return FileUtils.readFileToString(file, Charsets.toCharset(string));
    }

    @Deprecated
    public static List readLines(File file) {
        return FileUtils.readLines(file, Charset.defaultCharset());
    }

    public static List readLines(File file, Charset charset) {
        return Files.readAllLines(file.toPath(), charset);
    }

    public static List readLines(File file, String string) {
        return FileUtils.readLines(file, Charsets.toCharset(string));
    }

    private static void requireAbsent(File file, String string) {
        if (file.exists()) {
            throw new FileExistsException(String.format("File element in parameter '%s' already exists: '%s'", string, file));
        }
    }

    private static void requireCanonicalPathsNotEquals(File file, File file2) {
        String string = file.getCanonicalPath();
        if (string.equals(file2.getCanonicalPath())) {
            throw new IllegalArgumentException(String.format("File canonical paths are equal: '%s' (file1='%s', file2='%s')", string, file, file2));
        }
    }

    private static void requireDirectoryExists(File file, String string) {
        Objects.requireNonNull(file, string);
        if (!file.isDirectory()) {
            if (file.exists()) {
                throw new IllegalArgumentException("Parameter '" + string + "' is not a directory: '" + file + "'");
            }
            throw new FileNotFoundException("Directory '" + file + "' does not exist.");
        }
    }

    private static void requireDirectoryIfExists(File file, String string) {
        Objects.requireNonNull(file, string);
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("Parameter '" + string + "' is not a directory: '" + file + "'");
        }
    }

    private static boolean setTimes(File file, File file2) {
        Objects.requireNonNull(file, "sourceFile");
        Objects.requireNonNull(file2, "targetFile");
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            BasicFileAttributeView basicFileAttributeView = Files.getFileAttributeView(file2.toPath(), BasicFileAttributeView.class, new LinkOption[0]);
            basicFileAttributeView.setTimes(basicFileAttributes.lastModifiedTime(), basicFileAttributes.lastAccessTime(), basicFileAttributes.creationTime());
            return true;
        }
        catch (IOException iOException) {
            return file2.setLastModified(file.lastModified());
        }
    }

    public static long sizeOf(File file) {
        return (Long)Uncheck.get(() -> PathUtils.sizeOf(file.toPath()));
    }

    public static BigInteger sizeOfAsBigInteger(File file) {
        return (BigInteger)Uncheck.get(() -> PathUtils.sizeOfAsBigInteger(file.toPath()));
    }

    public static long sizeOfDirectory(File file) {
        try {
            FileUtils.requireDirectoryExists(file, "directory");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UncheckedIOException(fileNotFoundException);
        }
        return (Long)Uncheck.get(() -> PathUtils.sizeOfDirectory(file.toPath()));
    }

    public static BigInteger sizeOfDirectoryAsBigInteger(File file) {
        try {
            FileUtils.requireDirectoryExists(file, "directory");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new UncheckedIOException(fileNotFoundException);
        }
        return (BigInteger)Uncheck.get(() -> PathUtils.sizeOfDirectoryAsBigInteger(file.toPath()));
    }

    public static Stream streamFiles(File file, boolean bl2, String ... stringArray) {
        IOFileFilter iOFileFilter = stringArray == null ? FileFileFilter.INSTANCE : FileFileFilter.INSTANCE.and(FileUtils.toSuffixFileFilter(stringArray));
        return PathUtils.walk(file.toPath(), iOFileFilter, FileUtils.toMaxDepth(bl2), false, FileVisitOption.FOLLOW_LINKS).map(Path::toFile);
    }

    public static File toFile(URL uRL) {
        if (uRL == null || !FileUtils.isFileProtocol(uRL)) {
            return null;
        }
        String string = uRL.getFile().replace('/', File.separatorChar);
        return new File(FileUtils.decodeUrl(string));
    }

    public static File[] toFiles(URL ... uRLArray) {
        if (IOUtils.length(uRLArray) == 0) {
            return EMPTY_FILE_ARRAY;
        }
        File[] fileArray = new File[uRLArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            URL uRL = uRLArray[i2];
            if (uRL == null) continue;
            if (!FileUtils.isFileProtocol(uRL)) {
                throw new IllegalArgumentException("Can only convert file URL to a File: " + uRL);
            }
            fileArray[i2] = FileUtils.toFile(uRL);
        }
        return fileArray;
    }

    private static List toList(Stream stream) {
        return stream.collect(Collectors.toList());
    }

    private static int toMaxDepth(boolean bl2) {
        return bl2 ? Integer.MAX_VALUE : 1;
    }

    private static String[] toSuffixes(String ... stringArray) {
        return (String[])Stream.of(Objects.requireNonNull(stringArray, "extensions")).map(string -> string.charAt(0) == '.' ? string : "." + string).toArray(String[]::new);
    }

    private static SuffixFileFilter toSuffixFileFilter(String ... stringArray) {
        return new SuffixFileFilter(FileUtils.toSuffixes(stringArray));
    }

    public static void touch(File file) {
        PathUtils.touch(Objects.requireNonNull(file, PROTOCOL_FILE).toPath());
    }

    public static URL[] toURLs(File ... fileArray) {
        Objects.requireNonNull(fileArray, "files");
        URL[] uRLArray = new URL[fileArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            uRLArray[i2] = fileArray[i2].toURI().toURL();
        }
        return uRLArray;
    }

    private static void validateMoveParameters(File file, File file2) {
        Objects.requireNonNull(file, "source");
        Objects.requireNonNull(file2, "destination");
        if (!file.exists()) {
            throw new FileNotFoundException("Source '" + file + "' does not exist");
        }
    }

    public static boolean waitFor(File file, int n2) {
        Objects.requireNonNull(file, PROTOCOL_FILE);
        return PathUtils.waitFor(file.toPath(), Duration.ofSeconds(n2), PathUtils.EMPTY_LINK_OPTION_ARRAY);
    }

    @Deprecated
    public static void write(File file, CharSequence charSequence) {
        FileUtils.write(file, charSequence, Charset.defaultCharset(), false);
    }

    @Deprecated
    public static void write(File file, CharSequence charSequence, boolean bl2) {
        FileUtils.write(file, charSequence, Charset.defaultCharset(), bl2);
    }

    public static void write(File file, CharSequence charSequence, Charset charset) {
        FileUtils.write(file, charSequence, charset, false);
    }

    public static void write(File file, CharSequence charSequence, Charset charset, boolean bl2) {
        FileUtils.writeStringToFile(file, Objects.toString(charSequence, null), charset, bl2);
    }

    public static void write(File file, CharSequence charSequence, String string) {
        FileUtils.write(file, charSequence, string, false);
    }

    public static void write(File file, CharSequence charSequence, String string, boolean bl2) {
        FileUtils.write(file, charSequence, Charsets.toCharset(string), bl2);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray) {
        FileUtils.writeByteArrayToFile(file, byArray, false);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, boolean bl2) {
        FileUtils.writeByteArrayToFile(file, byArray, 0, byArray.length, bl2);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, int n2, int n3) {
        FileUtils.writeByteArrayToFile(file, byArray, n2, n3, false);
    }

    public static void writeByteArrayToFile(File file, byte[] byArray, int n2, int n3, boolean bl2) {
        try (OutputStream outputStream = FileUtils.newOutputStream(file, bl2);){
            outputStream.write(byArray, n2, n3);
        }
    }

    public static void writeLines(File file, Collection collection) {
        FileUtils.writeLines(file, null, collection, null, false);
    }

    public static void writeLines(File file, Collection collection, boolean bl2) {
        FileUtils.writeLines(file, null, collection, null, bl2);
    }

    public static void writeLines(File file, Collection collection, String string) {
        FileUtils.writeLines(file, null, collection, string, false);
    }

    public static void writeLines(File file, Collection collection, String string, boolean bl2) {
        FileUtils.writeLines(file, null, collection, string, bl2);
    }

    public static void writeLines(File file, String string, Collection collection) {
        FileUtils.writeLines(file, string, collection, null, false);
    }

    public static void writeLines(File file, String string, Collection collection, boolean bl2) {
        FileUtils.writeLines(file, string, collection, null, bl2);
    }

    public static void writeLines(File file, String string, Collection collection, String string2) {
        FileUtils.writeLines(file, string, collection, string2, false);
    }

    public static void writeLines(File file, String string, Collection collection, String string2, boolean bl2) {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(FileUtils.newOutputStream(file, bl2));){
            IOUtils.writeLines(collection, string2, (OutputStream)bufferedOutputStream, string);
        }
    }

    @Deprecated
    public static void writeStringToFile(File file, String string) {
        FileUtils.writeStringToFile(file, string, Charset.defaultCharset(), false);
    }

    @Deprecated
    public static void writeStringToFile(File file, String string, boolean bl2) {
        FileUtils.writeStringToFile(file, string, Charset.defaultCharset(), bl2);
    }

    public static void writeStringToFile(File file, String string, Charset charset) {
        FileUtils.writeStringToFile(file, string, charset, false);
    }

    public static void writeStringToFile(File file, String string, Charset charset, boolean bl2) {
        try (OutputStream outputStream = FileUtils.newOutputStream(file, bl2);){
            IOUtils.write(string, outputStream, charset);
        }
    }

    public static void writeStringToFile(File file, String string, String string2) {
        FileUtils.writeStringToFile(file, string, string2, false);
    }

    public static void writeStringToFile(File file, String string, String string2, boolean bl2) {
        FileUtils.writeStringToFile(file, string, Charsets.toCharset(string2), bl2);
    }

    @Deprecated
    public FileUtils() {
    }
}

