/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;

public enum FileSystem {
    GENERIC(4096, false, false, Integer.MAX_VALUE, Integer.MAX_VALUE, new int[]{0}, new String[0], false, false, '/'),
    LINUX(8192, true, true, 255, 4096, new int[]{0, 47}, new String[0], false, false, '/'),
    MAC_OSX(4096, true, true, 255, 1024, new int[]{0, 47, 58}, new String[0], false, false, '/'),
    WINDOWS(4096, false, true, 255, 32000, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 34, 42, 47, 58, 60, 62, 63, 92, 124}, new String[]{"AUX", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "COM\u00b2", "COM\u00b3", "COM\u00b9", "CON", "CONIN$", "CONOUT$", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "LPT\u00b2", "LPT\u00b3", "LPT\u00b9", "NUL", "PRN"}, true, true, '\\');

    private static final boolean IS_OS_LINUX;
    private static final boolean IS_OS_MAC;
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    private static final boolean IS_OS_WINDOWS;
    private static final FileSystem CURRENT;
    private final int blockSize;
    private final boolean casePreserving;
    private final boolean caseSensitive;
    private final int[] illegalFileNameChars;
    private final int maxFileNameLength;
    private final int maxPathLength;
    private final String[] reservedFileNames;
    private final boolean reservedFileNamesExtensions;
    private final boolean supportsDriveLetter;
    private final char nameSeparator;
    private final char nameSeparatorOther;

    private static FileSystem current() {
        if (IS_OS_LINUX) {
            return LINUX;
        }
        if (IS_OS_MAC) {
            return MAC_OSX;
        }
        if (IS_OS_WINDOWS) {
            return WINDOWS;
        }
        return GENERIC;
    }

    public static FileSystem getCurrent() {
        return CURRENT;
    }

    private static boolean getOsMatchesName(String string) {
        return FileSystem.isOsNameMatch(FileSystem.getSystemProperty("os.name"), string);
    }

    private static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            System.err.println("Caught a SecurityException reading the system property '" + string + "'; the SystemUtils property value will default to null.");
            return null;
        }
    }

    private static int indexOf(CharSequence charSequence, int n2, int n3) {
        if (charSequence instanceof String) {
            return ((String)charSequence).indexOf(n2, n3);
        }
        int n4 = charSequence.length();
        if (n3 < 0) {
            n3 = 0;
        }
        if (n2 < 65536) {
            for (int i2 = n3; i2 < n4; ++i2) {
                if (charSequence.charAt(i2) != n2) continue;
                return i2;
            }
            return -1;
        }
        if (n2 <= 0x10FFFF) {
            char[] cArray = Character.toChars(n2);
            for (int i3 = n3; i3 < n4 - 1; ++i3) {
                char c2 = charSequence.charAt(i3);
                char c3 = charSequence.charAt(i3 + 1);
                if (c2 != cArray[0] || c3 != cArray[1]) continue;
                return i3;
            }
        }
        return -1;
    }

    private static boolean isOsNameMatch(String string, String string2) {
        if (string == null) {
            return false;
        }
        return string.toUpperCase(Locale.ROOT).startsWith(string2.toUpperCase(Locale.ROOT));
    }

    private static String replace(String string, char c2, char c3) {
        return string == null ? null : string.replace(c2, c3);
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private FileSystem(boolean bl2, int n3, int n4, int[] nArray, String[] stringArray, boolean bl3, boolean bl4, char c2) {
        void var12_10;
        void var11_9;
        this.blockSize = bl2 ? 1 : 0;
        this.maxFileNameLength = (int)nArray;
        this.maxPathLength = (int)stringArray;
        this.illegalFileNameChars = (int[])Objects.requireNonNull(bl3, "illegalFileNameChars");
        this.reservedFileNames = (String[])Objects.requireNonNull(bl4, "reservedFileNames");
        this.reservedFileNamesExtensions = c2;
        this.caseSensitive = n3;
        this.casePreserving = n4;
        this.supportsDriveLetter = var11_9;
        this.nameSeparator = var12_10;
        this.nameSeparatorOther = FilenameUtils.flipSeparator((char)var12_10);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public char[] getIllegalFileNameChars() {
        char[] cArray = new char[this.illegalFileNameChars.length];
        for (int i2 = 0; i2 < this.illegalFileNameChars.length; ++i2) {
            cArray[i2] = (char)this.illegalFileNameChars[i2];
        }
        return cArray;
    }

    public int[] getIllegalFileNameCodePoints() {
        return (int[])this.illegalFileNameChars.clone();
    }

    public int getMaxFileNameLength() {
        return this.maxFileNameLength;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public char getNameSeparator() {
        return this.nameSeparator;
    }

    public String[] getReservedFileNames() {
        return (String[])this.reservedFileNames.clone();
    }

    public boolean isCasePreserving() {
        return this.casePreserving;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    private boolean isIllegalFileNameChar(int n2) {
        return Arrays.binarySearch(this.illegalFileNameChars, n2) >= 0;
    }

    public boolean isLegalFileName(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0 || charSequence.length() > this.maxFileNameLength) {
            return false;
        }
        if (this.isReservedFileName(charSequence)) {
            return false;
        }
        return charSequence.chars().noneMatch(this::isIllegalFileNameChar);
    }

    public boolean isReservedFileName(CharSequence charSequence) {
        CharSequence charSequence2 = this.reservedFileNamesExtensions ? this.trimExtension(charSequence) : charSequence;
        return Arrays.binarySearch(this.reservedFileNames, charSequence2) >= 0;
    }

    public String normalizeSeparators(String string) {
        return FileSystem.replace(string, this.nameSeparatorOther, this.nameSeparator);
    }

    public boolean supportsDriveLetter() {
        return this.supportsDriveLetter;
    }

    public String toLegalFileName(String string, char c2) {
        if (this.isIllegalFileNameChar(c2)) {
            throw new IllegalArgumentException(String.format("The replacement character '%s' cannot be one of the %s illegal characters: %s", c2 == '\u0000' ? "\\0" : Character.valueOf(c2), this.name(), Arrays.toString(this.illegalFileNameChars)));
        }
        String string2 = string.length() > this.maxFileNameLength ? string.substring(0, this.maxFileNameLength) : string;
        int[] nArray = string2.chars().map(n3 -> this.isIllegalFileNameChar(n3) ? c2 : n3).toArray();
        return new String(nArray, 0, nArray.length);
    }

    CharSequence trimExtension(CharSequence charSequence) {
        int n2 = FileSystem.indexOf(charSequence, 46, 0);
        return n2 < 0 ? charSequence : charSequence.subSequence(0, n2);
    }

    static {
        IS_OS_LINUX = FileSystem.getOsMatchesName("Linux");
        IS_OS_MAC = FileSystem.getOsMatchesName("Mac");
        IS_OS_WINDOWS = FileSystem.getOsMatchesName(OS_NAME_WINDOWS_PREFIX);
        CURRENT = FileSystem.current();
    }
}

