/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FileCleaningTracker$Reaper;
import org.apache.commons.io.FileCleaningTracker$Tracker;
import org.apache.commons.io.FileDeleteStrategy;

public class FileCleaningTracker {
    ReferenceQueue q = new ReferenceQueue();
    final Collection trackers = Collections.synchronizedSet(new HashSet());
    final List deleteFailures = Collections.synchronizedList(new ArrayList());
    volatile boolean exitWhenFinished;
    Thread reaper;

    private synchronized void addTracker(String string, Object object, FileDeleteStrategy fileDeleteStrategy) {
        if (this.exitWhenFinished) {
            throw new IllegalStateException("No new trackers can be added once exitWhenFinished() is called");
        }
        if (this.reaper == null) {
            this.reaper = new FileCleaningTracker$Reaper(this);
            this.reaper.start();
        }
        this.trackers.add(new FileCleaningTracker$Tracker(string, fileDeleteStrategy, object, this.q));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void exitWhenFinished() {
        this.exitWhenFinished = true;
        if (this.reaper != null) {
            Thread thread = this.reaper;
            synchronized (thread) {
                this.reaper.interrupt();
            }
        }
    }

    public List getDeleteFailures() {
        return new ArrayList(this.deleteFailures);
    }

    public int getTrackCount() {
        return this.trackers.size();
    }

    public void track(File file, Object object) {
        this.track(file, object, null);
    }

    public void track(File file, Object object, FileDeleteStrategy fileDeleteStrategy) {
        Objects.requireNonNull(file, "file");
        this.addTracker(file.getPath(), object, fileDeleteStrategy);
    }

    public void track(Path path, Object object) {
        this.track(path, object, null);
    }

    public void track(Path path, Object object, FileDeleteStrategy fileDeleteStrategy) {
        Objects.requireNonNull(path, "file");
        this.addTracker(path.toAbsolutePath().toString(), object, fileDeleteStrategy);
    }

    public void track(String string, Object object) {
        this.track(string, object, null);
    }

    public void track(String string, Object object, FileDeleteStrategy fileDeleteStrategy) {
        Objects.requireNonNull(string, "path");
        this.addTracker(string, object, fileDeleteStrategy);
    }
}

